<?php
header('Content-Type: application/json');
require_once 'config/database.php';
// Enable CORS
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET, POST');
header('Access-Control-Allow-Headers: Content-Type');
session_start();
try {
    // Check if session exists and is valid
    $isLoggedIn = false;
    $sessionInfo = [];
    if (isset($_SESSION['admin_logged_in']) && $_SESSION['admin_logged_in'] === true) {
        $isLoggedIn = true;
        $sessionInfo = [
            'admin_id' => $_SESSION['admin_id'] ?? null,
            'username' => $_SESSION['admin_username'] ?? 'Admin',
            'login_time' => $_SESSION['login_time'] ?? null
        ];
    }
    // If we have a session ID, verify it's still valid in database
    if ($isLoggedIn && isset($_SESSION['admin_id'])) {
        $stmt = $pdo->prepare("SELECT id, username FROM admin_users WHERE id = ? AND status = 'active'");
        $stmt->execute([$_SESSION['admin_id']]);
        $admin = $stmt->fetch(PDO::FETCH_ASSOC);
        if (!$admin) {
            // Admin not found or inactive, destroy session
            $isLoggedIn = false;
            session_destroy();
            $sessionInfo = [];
        }
    }
    echo json_encode([
        'success' => true,
        'logged_in' => $isLoggedIn,
        'session_info' => $sessionInfo,
        'message' => $isLoggedIn ? 'Session valid' : 'No valid session'
    ]);
} catch (Exception $e) {
    echo json_encode([
        'success' => false,
        'logged_in' => false,
        'session_info' => [],
        'message' => 'Error checking session: ' . $e->getMessage()
    ]);
}
?>
