<?php
// Script untuk generate data dummy lucky_wheel_daily_stats 7 hari terakhir
date_default_timezone_set('Asia/Jakarta');
require_once __DIR__ . '/../config/database.php';
for ($i = 6; $i >= 0; $i--) {
    $date = date('Y-m-d', strtotime("-$i days"));
    // Random data
    $spins = rand(10, 50);
    $vouchers = rand(5, $spins);
    $prizes = rand(3, $vouchers);
    // Cek apakah sudah ada data
    $stmt = $pdo->prepare("SELECT COUNT(*) FROM lucky_wheel_daily_stats WHERE stat_date = ?");
    $stmt->execute([$date]);
    if ($stmt->fetchColumn() > 0) {
        // Update
        $update = $pdo->prepare("UPDATE lucky_wheel_daily_stats SET total_spins=?, total_vouchers_used=?, total_prizes_claimed=? WHERE stat_date=?");
        $update->execute([$spins, $vouchers, $prizes, $date]);
    } else {
        // Insert
        $insert = $pdo->prepare("INSERT INTO lucky_wheel_daily_stats (stat_date, total_spins, total_vouchers_used, total_prizes_claimed, jackpot_count, cash_prizes_count, bonus_count, voucher_prizes_count, try_again_count) VALUES (?, ?, ?, ?, 0, 0, 0, 0, 0)");
        $insert->execute([$date, $spins, $vouchers, $prizes]);
    }
}
echo "Dummy data lucky_wheel_daily_stats 7 hari terakhir berhasil di-generate!";
