<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Dashboard - Lucky Wheel Admin</title>    <link rel="stylesheet" href="../css/admin.css">
    <link rel="stylesheet" href="css/dashboard-layout.css">
    <link rel="stylesheet" href="css/dashboard-widgets.css">
    <link rel="stylesheet" href="css/dashboard.css">
    <!-- Font Awesome -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
    <!-- AOS Animation -->
    <link href="https://unpkg.com/aos@2.3.1/dist/aos.css" rel="stylesheet">
    <!-- Chart.js -->
    <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
</head>
<body>    <div class="admin-container">
        <!-- Progress Loading Bar -->
        <div class="loading-bar">
            <div class="loading-progress"></div>
        </div>
        
        <header class="admin-header">
            <div class="header-left">
                <div class="logo">
                    <img src="../../assets/img/logo-lembagatoto.webp" alt="Lucky Wheel Logo">
                </div>
                <div class="header-info">
                    <h1>Dashboard Admin</h1>
                    <p class="header-subtitle">Lucky Wheel Management System</p>
                </div>
            </div>
            <div class="header-actions">
                <div class="weather-widget">
                    <i class="fas fa-sun"></i>
                    <span>28°C</span>
                </div>
                <span class="date-display" id="live-date">24 Juni 2025</span>
                <button class="header-btn refresh-btn" title="Refresh Data"><i class="fas fa-sync-alt"></i></button>
                <button class="header-btn notifications-btn" title="Notifikasi"><i class="fas fa-bell"></i><span class="notification-badge">3</span></button>
                <div class="user-profile">
                    <img src="../../assets/img/favicon.ico" alt="Admin" class="profile-avatar">
                    <span class="profile-name">Admin</span>
                </div>
            </div>
        </header>

        <div class="dashboard-container">
            <div class="admin-sidebar">
                <nav class="admin-nav">                    <ul>
                        <li class="active"><a href="index.html"><i class="fas fa-tachometer-alt"></i> <span>Dashboard</span></a></li>
                        <li><a href="../vouchers/index.html"><i class="fas fa-ticket-alt"></i> <span>Voucher</span></a></li>
                        <li><a href="../hadiah/index.html"><i class="fas fa-gift"></i> <span>Hadiah</span></a></li>
                        <li><a href="../pengguna/index.html"><i class="fas fa-users"></i> <span>Pemenang</span></a></li>
                        <li><a href="#"><i class="fas fa-chart-bar"></i> <span>Statistik</span></a></li>
                        <li><a href="#"><i class="fas fa-cog"></i> <span>Pengaturan</span></a></li>
                    </ul>
                </nav>
                <div class="admin-user">
                    <div class="user-avatar">
                        <i class="fas fa-user-circle"></i>
                    </div>
                    <div class="user-info">
                        <p class="user-name">Admin</p>
                        <button id="logout-btn" class="small-btn"><i class="fas fa-sign-out-alt"></i> Logout</button>
                    </div>
                </div>
            </div>            <div class="dashboard-content">
                <!-- Welcome Section with Modern Cards -->
                <div class="dashboard-header">
                    <div class="welcome-content">
                        <h2>Selamat Datang, LEMBAGATOTO!</h2>
                        <p>Berikut adalah ikhtisar aktivitas Lucky Wheel hari ini. Semua data diperbarui secara real-time.</p>
                        <div class="quick-info">
                            <span class="info-badge"><i class="fas fa-clock"></i> Last Update: <span id="last-update">Just Now</span></span>
                            <span class="info-badge"><i class="fas fa-wifi"></i> Status: <span class="status-online">Online</span></span>
                        </div>
                    </div>
                    <div class="dashboard-actions">
                        <button class="action-btn primary" id="add-voucher-btn">
                            <i class="fas fa-plus"></i>
                            <span>Tambah Voucher</span>
                        </button>
                        <button class="action-btn secondary" id="export-btn">
                            <i class="fas fa-download"></i>
                            <span>Export</span>
                        </button>
                    </div>
                </div>                  <!-- Enhanced Quick Stats Cards - Lucky Wheel Real-Time -->
                <div class="stats-section">
                    <div class="section-title">
                        <h3>Statistik Lucky Wheel Real-Time</h3>
                        <div class="title-line"></div>
                        <div class="auto-refresh-indicator">
                            <i class="fas fa-sync-alt" id="refresh-icon"></i>
                            <span>Auto-refresh: <span id="refresh-countdown">30</span>s</span>
                        </div>
                    </div>
                    <div class="stats-row">
                        <div class="stat-card" data-aos="fade-up" data-aos-delay="100">
                            <div class="stat-icon orange">
                                <i class="fas fa-ticket-alt"></i>
                                <div class="icon-pulse"></div>
                            </div>
                            <div class="stat-details">
                                <h4>Total Voucher Digunakan</h4>
                                <p class="stat-number" id="total-vouchers-used-stat">0</p>
                                <div class="stat-footer">
                                    <span class="stat-change">Hari ini: <span id="today-vouchers">0</span></span>
                                    <span class="stat-period">voucher</span>
                                </div>
                            </div>
                        </div>
                        
                        <div class="stat-card" data-aos="fade-up" data-aos-delay="200">
                            <div class="stat-icon blue">
                                <i class="fas fa-sync-alt"></i>
                                <div class="icon-pulse"></div>
                            </div>
                            <div class="stat-details">
                                <h4>Total Spin</h4>
                                <p class="stat-number" id="total-spins-stat">0</p>
                                <div class="stat-footer">
                                    <span class="stat-change">Hari ini: <span id="today-spins">0</span></span>
                                    <span class="stat-period">putaran</span>
                                </div>
                            </div>
                        </div>
                        
                        <div class="stat-card" data-aos="fade-up" data-aos-delay="300">
                            <div class="stat-icon green">
                                <i class="fas fa-gift"></i>
                                <div class="icon-pulse"></div>
                            </div>
                            <div class="stat-details">
                                <h4>Total Hadiah Diklaim</h4>
                                <p class="stat-number" id="total-prizes-stat">0</p>
                                <div class="stat-footer">
                                    <span class="stat-change">Hari ini: <span id="today-prizes">0</span></span>
                                    <span class="stat-period">hadiah</span>
                                </div>
                            </div>
                        </div>
                        
                        <div class="stat-card" data-aos="fade-up" data-aos-delay="400">
                            <div class="stat-icon red">
                                <i class="fas fa-trophy"></i>
                                <div class="icon-pulse"></div>
                            </div>
                            <div class="stat-details">
                                <h4>Jackpot & Bonus</h4>
                                <p class="stat-number" id="total-jackpots-stat">0</p>
                                <div class="stat-footer">
                                    <span class="stat-change">Hari ini: <span id="today-jackpots">0</span></span>
                                    <span class="stat-period">jackpot/bonus</span>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>                  <!-- Enhanced Charts Section - Lucky Wheel -->
                <div class="charts-container">
                    <div class="chart-card main-chart" data-aos="fade-right">
                        <div class="chart-header">
                            <div class="chart-title">
                                <h3>Aktivitas Lucky Wheel Harian</h3>
                                <p>Tren spin dan voucher 7 hari terakhir</p>
                            </div>
                            <div class="chart-actions">
                                <button class="chart-btn active" data-period="7days">7 Hari</button>
                                <button class="chart-btn" data-period="30days">30 Hari</button>
                            </div>
                        </div>
                        <div class="chart-body">
                            <canvas id="lucky-wheel-activity-chart"></canvas>
                        </div>
                        <div class="chart-stats">
                            <div class="mini-stat">
                                <span class="mini-stat-label">Rata-rata Spin/Hari</span>
                                <span class="mini-stat-value" id="avg-spins-day">0</span>
                            </div>
                            <div class="mini-stat">
                                <span class="mini-stat-label">Rata-rata Voucher/Hari</span>
                                <span class="mini-stat-value" id="avg-vouchers-day">0</span>
                            </div>
                            <div class="mini-stat">
                                <span class="mini-stat-label">Win Rate</span>
                                <span class="mini-stat-value" id="win-rate">0%</span>
                            </div>
                        </div>
                    </div>
                    
                    <div class="chart-card side-chart" data-aos="fade-left">
                        <div class="chart-header">
                            <div class="chart-title">
                                <h3>Distribusi Hadiah Lucky Wheel</h3>
                                <p>Real-time dari database</p>
                            </div>
                        </div>
                        <div class="chart-body">
                            <canvas id="lucky-wheel-prizes-chart"></canvas>
                        </div>
                        <div class="chart-legend" id="prize-legend">
                            <!-- Legend akan diisi otomatis dari data -->
                        </div>
                    </div>
                </div>
                  <!-- Enhanced Recent Activity & Quick Actions -->
                <div class="dashboard-bottom">
                    <div class="activity-card" data-aos="fade-up" data-aos-delay="100">
                        <div class="card-header">
                            <div class="header-content">
                                <h3>Aktivitas Terbaru</h3>
                                <p>Pantau aktivitas sistem secara real-time</p>
                            </div>
                            <div class="header-actions">
                                <button class="small-btn filter-btn" title="Filter"><i class="fas fa-filter"></i></button>
                                <button class="small-btn view-all-btn">Lihat Semua</button>
                            </div>
                        </div>
                        <div class="activity-list">
                            <div class="activity-item new">
                                <div class="activity-icon green">
                                    <i class="fas fa-check-circle"></i>
                                </div>
                                <div class="activity-details">
                                    <p class="activity-text">Voucher <strong>VIP-54321</strong> berhasil digunakan</p>
                                    <div class="activity-meta">
                                        <span class="activity-time">10 menit lalu</span>
                                        <span class="activity-user">oleh User123</span>
                                    </div>
                                </div>
                                <div class="activity-status success">Berhasil</div>
                            </div>
                            <div class="activity-item">
                                <div class="activity-icon orange">
                                    <i class="fas fa-plus-circle"></i>
                                </div>
                                <div class="activity-details">
                                    <p class="activity-text">20 voucher baru telah digenerate</p>
                                    <div class="activity-meta">
                                        <span class="activity-time">45 menit lalu</span>
                                        <span class="activity-user">oleh Admin</span>
                                    </div>
                                </div>
                                <div class="activity-status info">Generate</div>
                            </div>
                            <div class="activity-item">
                                <div class="activity-icon blue">
                                    <i class="fas fa-gift"></i>
                                </div>
                                <div class="activity-details">
                                    <p class="activity-text">Hadiah <strong>Rp 500.000</strong> telah diberikan</p>
                                    <div class="activity-meta">
                                        <span class="activity-time">1 jam lalu</span>
                                        <span class="activity-user">kepada Winner456</span>
                                    </div>
                                </div>
                                <div class="activity-status success">Hadiah</div>
                            </div>
                            <div class="activity-item">
                                <div class="activity-icon red">
                                    <i class="fas fa-exclamation-triangle"></i>
                                </div>
                                <div class="activity-details">
                                    <p class="activity-text">5 voucher telah kedaluwarsa</p>
                                    <div class="activity-meta">
                                        <span class="activity-time">3 jam lalu</span>
                                        <span class="activity-user">sistem</span>
                                    </div>
                                </div>
                                <div class="activity-status warning">Expired</div>
                            </div>
                            <div class="activity-item">
                                <div class="activity-icon purple">
                                    <i class="fas fa-user-plus"></i>
                                </div>
                                <div class="activity-details">
                                    <p class="activity-text">Admin baru <strong>Operator1</strong> ditambahkan</p>
                                    <div class="activity-meta">
                                        <span class="activity-time">1 hari lalu</span>
                                        <span class="activity-user">oleh SuperAdmin</span>
                                    </div>
                                </div>
                                <div class="activity-status info">User</div>
                            </div>
                        </div>
                    </div>
                    
                    <div class="quick-actions" data-aos="fade-up" data-aos-delay="200">
                        <div class="actions-header">
                            <h3>Aksi Cepat</h3>
                            <p>Akses langsung ke fitur utama</p>
                        </div>
                        <div class="actions-grid">
                            <a href="../vouchers/index.html" class="action-btn primary">
                                <div class="btn-icon">
                                    <i class="fas fa-plus-circle"></i>
                                </div>
                                <div class="btn-content">
                                    <span class="btn-title">Generate Voucher</span>
                                    <span class="btn-desc">Buat voucher baru</span>
                                </div>
                            </a>
                            <a href="#" class="action-btn secondary">
                                <div class="btn-icon">
                                    <i class="fas fa-file-export"></i>
                                </div>
                                <div class="btn-content">
                                    <span class="btn-title">Export Data</span>
                                    <span class="btn-desc">Download laporan</span>
                                </div>
                            </a>
                            <a href="#" class="action-btn info">
                                <div class="btn-icon">
                                    <i class="fas fa-bell"></i>
                                </div>
                                <div class="btn-content">
                                    <span class="btn-title">Kirim Notifikasi</span>
                                    <span class="btn-desc">Broadcast message</span>
                                </div>
                            </a>
                            <a href="#" class="action-btn warning">
                                <div class="btn-icon">
                                    <i class="fas fa-cogs"></i>
                                </div>
                                <div class="btn-content">
                                    <span class="btn-title">Pengaturan</span>
                                    <span class="btn-desc">Konfigurasi sistem</span>
                                </div>
                            </a>
                            <a href="#" class="action-btn success">
                                <div class="btn-icon">
                                    <i class="fas fa-chart-line"></i>
                                </div>
                                <div class="btn-content">
                                    <span class="btn-title">Laporan</span>
                                    <span class="btn-desc">Analytics detail</span>
                                </div>
                            </a>
                            <a href="#" class="action-btn danger">
                                <div class="btn-icon">
                                    <i class="fas fa-database"></i>
                                </div>
                                <div class="btn-content">
                                    <span class="btn-title">Backup</span>
                                    <span class="btn-desc">Cadangkan data</span>
                                </div>
                            </a>
                        </div>
                    </div>
                </div>                <!-- Enhanced Footer -->
                <footer class="dashboard-footer">
                    <div class="footer-content">
                        <div class="footer-left">
                            <p>&copy; 2025 Lucky Wheel Admin. All rights reserved.</p>
                            <p class="footer-version">Version 2.1.0</p>
                        </div>
                        <div class="footer-right">
                            <div class="footer-links">
                                <a href="#" class="footer-link">Privacy Policy</a>
                                <a href="#" class="footer-link">Terms of Service</a>
                                <a href="#" class="footer-link">Support</a>
                            </div>
                            <div class="footer-social">
                                <a href="#" class="social-link" title="Facebook" aria-label="Kunjungi Facebook"><i class="fab fa-facebook"></i></a>
                                <a href="#" class="social-link" title="Twitter" aria-label="Kunjungi Twitter"><i class="fab fa-twitter"></i></a>
                                <a href="#" class="social-link" title="Instagram" aria-label="Kunjungi Instagram"><i class="fab fa-instagram"></i></a>
                            </div>
                        </div>
                    </div>
                </footer>
            </div>
        </div>
        
        <!-- Toast Notification Container -->
        <div class="toast-container" id="toast-container"></div>
        
        <!-- Modal for Quick Actions -->
        <div class="modal fade" id="quickActionModal">
            <div class="modal-dialog">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title">Aksi Cepat</h5>
                        <button type="button" class="close-modal" data-dismiss="modal" title="Tutup" aria-label="Tutup modal">
                            <i class="fas fa-times"></i>
                        </button>
                    </div>
                    <div class="modal-body">
                        <p>Fitur ini akan segera tersedia!</p>
                    </div>
                </div>
            </div>
        </div>
    </div>    <!-- AOS Animation -->
    <script src="https://unpkg.com/aos@2.3.1/dist/aos.js"></script>
    <script src="js/dashboard-admin.js"></script>
    <script src="js/dashboard.js"></script>
    <script>
    // Definisi fungsi custom modal untuk dashboard
    function showCustomConfirm(message, title = 'Konfirmasi') {
        return new Promise((resolve) => {
            // Remove existing popup
            const existingPopup = document.querySelector('.custom-popup-overlay');
            if (existingPopup) {
                existingPopup.remove();
            }
            
            // Prevent body scroll
            document.body.classList.add('popup-open');
            
            // Create popup HTML
            const popupHTML = `
                <div class="custom-popup-overlay">
                    <div class="custom-popup">
                        <div class="custom-popup-icon warning">
                            <i class="fas fa-question-circle"></i>
                        </div>
                        <div class="custom-popup-title">${title}</div>
                        <div class="custom-popup-message">${message}</div>
                        <div class="custom-popup-buttons">
                            <button class="custom-popup-btn secondary" onclick="closeCustomPopup(false)">
                                <i class="fas fa-times"></i> Batal
                            </button>
                            <button class="custom-popup-btn primary" onclick="closeCustomPopup(true)">
                                <i class="fas fa-check"></i> Ya
                            </button>
                        </div>
                    </div>
                </div>
            `;
            
            // Add to body
            document.body.insertAdjacentHTML('beforeend', popupHTML);
            
            // Show popup with animation
            const popup = document.querySelector('.custom-popup-overlay');
            setTimeout(() => {
                popup.classList.add('show');
            }, 10);
            
            // Store resolve function
            window.customPopupResolve = resolve;
        });
    }
    
    function closeCustomPopup(result = true) {
        const popup = document.querySelector('.custom-popup-overlay');
        if (popup) {
            popup.classList.remove('show');
            // Restore body scroll
            document.body.classList.remove('popup-open');
            setTimeout(() => {
                popup.remove();
                if (window.customPopupResolve) {
                    window.customPopupResolve(result);
                    window.customPopupResolve = null;
                }
            }, 300);
        }
    }
    
    // Make functions global
    window.showCustomConfirm = showCustomConfirm;
    window.closeCustomPopup = closeCustomPopup;
    
    // Universal logout handler untuk dashboard
    document.addEventListener('DOMContentLoaded', function() {
        const logoutBtn = document.getElementById('logout-btn');
        if (logoutBtn && !logoutBtn.hasAttribute('data-logout-attached')) {
            logoutBtn.addEventListener('click', async function(event) {
                event.preventDefault();
                
                // Menggunakan showCustomConfirm jika tersedia
                let confirmed = false;
                if (typeof showCustomConfirm === 'function') {
                    confirmed = await showCustomConfirm('Apakah Anda yakin ingin keluar?', 'Konfirmasi Logout');
                } else {
                    confirmed = confirm('Apakah Anda yakin ingin keluar?');
                }
                
                if (!confirmed) return;
                
                try {
                    // Panggil endpoint logout untuk membersihkan session
                    await fetch('../login.php', {
                        method: 'POST',
                        headers: {
                            'Content-Type': 'application/json',
                            'X-Requested-With': 'XMLHttpRequest'
                        },
                        body: JSON.stringify({
                            action: 'logout'
                        })
                    });
                } catch (error) {
                    console.error('Logout error:', error);
                }
                
                // Redirect ke halaman login
                window.location.href = '../index.html';
            });
            
            logoutBtn.setAttribute('data-logout-attached', '1');
        }
    });
    </script>
</body>
</html>
