// Prizes Admin Page Functionality (tanpa Lucky Wheel logic)
// Hanya handle AOS, event logout, dan utilitas admin
// Initialize AOS
AOS.init({
    duration: 800,
    easing: 'ease-in-out',
    once: true,
    offset: 100
});
// Initial auth check before page load
const adminLoggedIn = localStorage.getItem('adminLoggedIn');
if (!adminLoggedIn) {
    }
// Fallback logout handler
function handleLogout(event) {
    event.preventDefault();
    event.stopPropagation();
    if (typeof showCustomConfirm === 'function') {
        showCustomConfirm('Apakah Anda yakin ingin keluar?', 'Konfirmasi Logout')
            .then(confirmed => {
                if (confirmed) {
                    localStorage.removeItem('adminLoggedIn');
                    if (typeof showCustomAlert === 'function') {
                        showCustomAlert('Logout berhasil!', 'success', 'Berhasil');
                    }
                    setTimeout(() => {
                        window.location.href = 'index.html';
                    }, 1500);
                }
            })
            .catch(error => {
                if (confirm('Apakah Anda yakin ingin keluar?')) {
                    window.location.href = 'index.html';
                }
            });
    } else {
        if (confirm('Apakah Anda yakin ingin keluar?')) {
            localStorage.removeItem('adminLoggedIn');
            window.location.href = 'index.html';
        }
    }
}