<?php
require_once __DIR__ . '/../config/database.php';
try {
    // Clear existing prizes
    $pdo->exec("DELETE FROM lucky_wheel_prizes");
    echo "✅ Data hadiah lama berhasil dihapus!<br>";
    // Insert 8 hadiah sesuai dengan wheel.js
    $wheelPrizes = [
        ['name' => 'JACKPOT 1JT', 'type' => 'money', 'value' => '1000000', 'icon' => 'fas fa-trophy', 'color' => '#FF5722', 'probability' => 1.00, 'position' => 1],
        ['name' => 'Rp 100,000', 'type' => 'money', 'value' => '100000', 'icon' => 'fas fa-coins', 'color' => '#FF9800', 'probability' => 10.00, 'position' => 2],
        ['name' => 'BONUS 500K', 'type' => 'bonus', 'value' => '500000', 'icon' => 'fas fa-star', 'color' => '#FFB74D', 'probability' => 5.00, 'position' => 3],
        ['name' => 'Voucher 50K', 'type' => 'voucher', 'value' => '50000', 'icon' => 'fas fa-ticket-alt', 'color' => '#FFCC80', 'probability' => 15.00, 'position' => 4],
        ['name' => 'Rp 200,000', 'type' => 'money', 'value' => '200000', 'icon' => 'fas fa-coins', 'color' => '#FF7043', 'probability' => 8.00, 'position' => 5],
        ['name' => 'Coba Lagi', 'type' => 'other', 'value' => '0', 'icon' => 'fas fa-redo-alt', 'color' => '#BF360C', 'probability' => 30.00, 'position' => 6],
        ['name' => 'BONUS 888K', 'type' => 'bonus', 'value' => '888000', 'icon' => 'fas fa-gem', 'color' => '#E64A19', 'probability' => 3.00, 'position' => 7],
        ['name' => 'Rp 300,000', 'type' => 'money', 'value' => '300000', 'icon' => 'fas fa-coins', 'color' => '#FFA726', 'probability' => 8.00, 'position' => 8]
    ];
    $stmt = $pdo->prepare("INSERT INTO lucky_wheel_prizes (name, type, value, icon, color, probability, position, status) VALUES (?, ?, ?, ?, ?, ?, ?, 'active')");
    foreach ($wheelPrizes as $prize) {
        $stmt->execute([$prize['name'], $prize['type'], $prize['value'], $prize['icon'], $prize['color'], $prize['probability'], $prize['position']]);
    }
    echo "✅ 8 hadiah baru berhasil ditambahkan sesuai wheel.js!<br>";
    // Verify total probability
    $stmt = $pdo->query("SELECT SUM(probability) as total_prob FROM lucky_wheel_prizes WHERE status = 'active'");
    $result = $stmt->fetch(PDO::FETCH_ASSOC);
    echo "📊 Total probabilitas: " . $result['total_prob'] . "%<br>";
    // Show all prizes
    $stmt = $pdo->query("SELECT * FROM lucky_wheel_prizes ORDER BY position");
    $prizes = $stmt->fetchAll(PDO::FETCH_ASSOC);
    echo "<br>🎯 Daftar hadiah yang telah disinkronkan:<br>";
    foreach ($prizes as $prize) {
        echo "- {$prize['name']} ({$prize['probability']}%) - {$prize['color']}<br>";
    }
    echo "<br>🎉 Sinkronisasi database selesai!";
} catch (PDOException $e) {
    echo "❌ Error: " . $e->getMessage();
}
?>
