// Tunggu dokumen selesai dimuat
document.addEventListener('DOMContentLoaded', function() {
    // Data untuk simulasi
    let voucherData = [];
    // Login state management
    let isLoggedIn = false;
    let currentAdmin = null;
    // Element references
    const loginSection = document.getElementById('login-section');
    const adminPanel = document.getElementById('admin-panel');
    const loginBtn = document.getElementById('login-btn');
    const logoutBtn = document.getElementById('logout-btn');
    const username = document.getElementById('username');
    const password = document.getElementById('password');
    const tabButtons = document.querySelectorAll('.admin-nav li');
    const tabContents = document.querySelectorAll('.tab-content');
    const generateBtn = document.getElementById('generate-btn');
    const refreshBtn = document.getElementById('refresh-vouchers');
    const exportCsvBtn = document.getElementById('export-csv');
    const exportJsonBtn = document.getElementById('export-json');
    const printVouchersBtn = document.getElementById('print-vouchers');
    // Tab switching
    tabButtons.forEach(button => {
        button.addEventListener('click', () => {
            const tabId = button.getAttribute('data-tab');
            tabButtons.forEach(btn => {
                btn.classList.remove('active');
            });
            tabContents.forEach(content => {
                content.classList.remove('active');
            });
            button.classList.add('active');
            document.getElementById(tabId).classList.add('active');
        });
    });
    // Login functionality with MySQL
    loginBtn.addEventListener('click', async () => {
        const usernameValue = username.value.trim();
        const passwordValue = password.value.trim();
          // Validation
        if (!usernameValue || !passwordValue) {
            showCustomAlert('Username dan password harus diisi!', 'error');
            return;
        }
        // Show loading state
        loginBtn.disabled = true;
        loginBtn.textContent = 'Loading...';
        try {
            const response = await fetch('login.php', {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/json',
                    'X-Requested-With': 'XMLHttpRequest'
                },
                body: JSON.stringify({
                    username: usernameValue,
                    password: passwordValue
                })
            });
            const result = await response.json();            if (result.success) {
                // Login berhasil - redirect ke dashboard
                showCustomAlert(`Selamat datang, ${result.data.username}!`, 'success', 'Login Berhasil!');
                setTimeout(() => {
                    window.location.href = 'dashboard/index.html';
                }, 2000);
            } else {
                // Login gagal
                showCustomAlert(result.message || 'Login gagal!', 'error');
            }
              } catch (error) {
            showCustomAlert('Terjadi kesalahan koneksi. Silakan coba lagi.', 'error');
        } finally {
            loginBtn.disabled = false;
            loginBtn.innerHTML = '<span class="btn-text">MASUK ADMIN</span><span class="btn-icon"><i class="fas fa-sign-in-alt"></i></span>';
        }
    });
      // Logout functionality with session cleanup
    logoutBtn.addEventListener('click', async () => {
        const confirmed = await showCustomConfirm('Apakah Anda yakin ingin keluar?', 'Konfirmasi Logout');
        if (!confirmed) return;
        try {
            // Call logout endpoint to cleanup session
            await fetch('login.php', {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/json',
                    'X-Requested-With': 'XMLHttpRequest'
                },
                body: JSON.stringify({
                    action: 'logout'
                })
            });
        } catch (error) {
            } finally {
            // Show login form, hide admin panel
            adminPanel.classList.add('hidden');
            loginSection.classList.remove('hidden');
            // Clear form
            username.value = '';
            password.value = '';
            showCustomAlert('Anda telah logout.', 'success', 'Logout Berhasil');
        }
    });
    // Generate voucher functionality
    generateBtn.addEventListener('click', () => {
        const count = parseInt(document.getElementById('voucher-count').value) || 1;
        const type = document.getElementById('voucher-type').value;
        const expiryDate = document.getElementById('expiry-date').value ? 
                          new Date(document.getElementById('expiry-date').value) : 
                          new Date(Date.now() + 30 * 24 * 60 * 60 * 1000); // Default 30 days
        const formattedExpiry = formatDate(expiryDate);
        // Limit voucher generation
        const safeCount = Math.min(count, 100);
        for (let i = 0; i < safeCount; i++) {
            const voucher = {
                code: generateVoucherCode(),
                created: formatDate(new Date()),
                type: type,
                expiry: formattedExpiry,
                status: 'active'
            };
            voucherData.push(voucher);
        }
        // Save to localStorage
        saveVoucherData();
        // Update UI
        updateVoucherTable();
        updateStats();
        // Show notification
        alert(`${safeCount} voucher berhasil dibuat!`);
    });
    // Refresh button
    refreshBtn.addEventListener('click', () => {
        loadVoucherData();
        updateVoucherTable();
        updateStats();
    });
    // Export functionality
    exportCsvBtn.addEventListener('click', () => {
        const csvContent = convertToCSV(voucherData);
        downloadFile(csvContent, 'voucher_data.csv', 'text/csv');
    });
    exportJsonBtn.addEventListener('click', () => {
        const jsonContent = JSON.stringify(voucherData, null, 2);
        downloadFile(jsonContent, 'voucher_data.json', 'application/json');
    });
    printVouchersBtn.addEventListener('click', () => {
        const printWindow = window.open('', '_blank');
        let printContent = `
            <html>
            <head>
                <title>Voucher Print</title>
                <style>
                    body { font-family: Arial, sans-serif; }
                    .voucher { 
                        border: 1px solid #ccc; 
                        margin: 10px; 
                        padding: 15px; 
                        width: 300px; 
                        display: inline-block;
                        border-radius: 5px;
                        position: relative;
                    }
                    .voucher-header { 
                        font-size: 18px; 
                        font-weight: bold; 
                        color: #FF6600;
                        margin-bottom: 10px;
                        border-bottom: 1px solid #eee;
                        padding-bottom: 5px;
                    }
                    .voucher-code { 
                        font-size: 22px; 
                        font-weight: bold; 
                        text-align: center; 
                        margin: 15px 0; 
                        letter-spacing: 1px;
                        background: #f9f9f9;
                        padding: 10px;
                        border-radius: 4px;
                    }
                    .voucher-details { font-size: 14px; margin-top: 10px; }
                    .voucher-expiry { font-weight: bold; color: #F44336; }
                    .watermark {
                        position: absolute;
                        top: 50%;
                        left: 50%;
                        transform: translate(-50%, -50%) rotate(-45deg);
                        opacity: 0.1;
                        font-size: 48px;
                        font-weight: bold;
                        z-index: -1;
                    }
                    @media print {
                        @page { margin: 0.5cm; }
                        body { padding: 0.5cm; }
                    }
                </style>
            </head>
            <body>
                <h1>Voucher Lucky Wheel</h1>
                <p>Total voucher: ${voucherData.filter(v => v.status === 'active').length}</p>
                <div class="vouchers-container">
        `;
        voucherData.filter(v => v.status === 'active').forEach(voucher => {
            const typeLabels = {
                'regular': 'Regular (1x Spin)',
                'premium': 'Premium (3x Spin + Bonus)',
                'vip': 'VIP (5x Spin + Bonus)'
            };
            printContent += `
                <div class="voucher">
                    <div class="watermark">LUCKY SPIN</div>
                    <div class="voucher-header">Lucky Wheel Voucher</div>
                    <div class="voucher-code">${voucher.code}</div>
                    <div class="voucher-details">
                        <p><strong>Tipe:</strong> ${typeLabels[voucher.type] || voucher.type}</p>
                        <p><strong>Dibuat:</strong> ${voucher.created}</p>
                        <p class="voucher-expiry"><strong>Kadaluarsa:</strong> ${voucher.expiry}</p>
                    </div>
                </div>
            `;
        });
        printContent += `
                </div>
            </body>
            </html>
        `;
        printWindow.document.open();
        printWindow.document.write(printContent);
        printWindow.document.close();
        // Give a small delay to load all resources
        setTimeout(() => {
            printWindow.print();
        }, 500);
    });
    // Function to generate a random voucher code
    function generateVoucherCode() {
        const chars = 'ABCDEFGHJKLMNPQRSTUVWXYZ23456789';
        const codeLength = 10;
        let code = '';
        for (let i = 0; i < codeLength; i++) {
            if (i > 0 && i % 5 === 0) {
                code += '-';
            }
            code += chars.charAt(Math.floor(Math.random() * chars.length));
        }
        return code;
    }
    // Format date to string
    function formatDate(date) {
        return date.toLocaleDateString('id-ID', {
            year: 'numeric',
            month: '2-digit',
            day: '2-digit'
        });
    }
    // Save voucher data to localStorage
    function saveVoucherData() {
        localStorage.setItem('voucherData', JSON.stringify(voucherData));
    }
    // Load voucher data from localStorage
    function loadVoucherData() {
        const savedData = localStorage.getItem('voucherData');
        if (savedData) {
            try {
                voucherData = JSON.parse(savedData);
            } catch (e) {
                voucherData = [];
            }
        }
    }
    // Update voucher table in UI
    function updateVoucherTable() {
        const tbody = document.getElementById('vouchers-list');
        tbody.innerHTML = '';
        if (voucherData.length === 0) {
            const emptyRow = document.createElement('tr');
            emptyRow.innerHTML = `
                <td colspan="6" style="text-align: center; padding: 20px;">
                    Belum ada data voucher. Generate voucher baru untuk memulai.
                </td>
            `;
            tbody.appendChild(emptyRow);
            return;
        }
        // Sort by creation date, newest first
        const sortedData = [...voucherData].sort((a, b) => {
            return new Date(b.created) - new Date(a.created);
        });
        sortedData.forEach(voucher => {
            const row = document.createElement('tr');
            // Create status badge
            const badgeClass = 
                voucher.status === 'active' ? 'badge-active' : 
                voucher.status === 'used' ? 'badge-used' : 
                'badge-expired';
            const badgeText = 
                voucher.status === 'active' ? 'Aktif' : 
                voucher.status === 'used' ? 'Terpakai' : 
                'Kadaluarsa';
            // Create type label
            const typeLabel = 
                voucher.type === 'regular' ? 'Regular' : 
                voucher.type === 'premium' ? 'Premium' : 
                voucher.type === 'vip' ? 'VIP' : 
                voucher.type;
            row.innerHTML = `
                <td><code>${voucher.code}</code></td>
                <td>${voucher.created}</td>
                <td>${typeLabel}</td>
                <td>${voucher.expiry}</td>
                <td><span class="badge ${badgeClass}">${badgeText}</span></td>
                <td>
                    <button class="action-btn mark-btn" data-code="${voucher.code}" data-action="mark-used" ${voucher.status !== 'active' ? 'disabled' : ''}>
                        <i class="fas fa-check-circle"></i> Tandai Terpakai
                    </button>
                    <button class="action-btn delete-btn" data-code="${voucher.code}" data-action="delete">
                        <i class="fas fa-trash-alt"></i> Hapus
                    </button>
                </td>
            `;
            tbody.appendChild(row);
        });
        // Attach event handlers to action buttons
        document.querySelectorAll('.mark-btn').forEach(btn => {
            btn.addEventListener('click', () => {
                const code = btn.getAttribute('data-code');
                markVoucherAsUsed(code);
            });
        });
        document.querySelectorAll('.delete-btn').forEach(btn => {
            btn.addEventListener('click', () => {
                const code = btn.getAttribute('data-code');
                deleteVoucher(code);
            });
        });
    }
    // Mark voucher as used
    function markVoucherAsUsed(code) {
        const index = voucherData.findIndex(v => v.code === code);
        if (index !== -1) {
            voucherData[index].status = 'used';
            saveVoucherData();
            updateVoucherTable();
            updateStats();
        }
    }
    // Delete voucher
    function deleteVoucher(code) {
        if (confirm('Apakah Anda yakin ingin menghapus voucher ini?')) {
            const index = voucherData.findIndex(v => v.code === code);
            if (index !== -1) {
                voucherData.splice(index, 1);
                saveVoucherData();
                updateVoucherTable();
                updateStats();
            }
        }
    }
    // Update statistics in UI
    function updateStats() {
        const totalVouchers = voucherData.length;
        const usedVouchers = voucherData.filter(v => v.status === 'used').length;
        const expiredVouchers = voucherData.filter(v => v.status === 'expired').length;
        const activeVouchers = totalVouchers - usedVouchers - expiredVouchers;
        document.getElementById('total-vouchers').textContent = totalVouchers;
        document.getElementById('used-vouchers').textContent = usedVouchers;
        document.getElementById('expired-vouchers').textContent = expiredVouchers;
        document.getElementById('active-vouchers').textContent = activeVouchers;
    }
    // Convert data to CSV
    function convertToCSV(data) {
        const headers = ['Kode Voucher', 'Tanggal Dibuat', 'Jenis', 'Kadaluarsa', 'Status'];
        const rows = data.map(item => {
            return [
                item.code, 
                item.created, 
                item.type, 
                item.expiry, 
                item.status
            ];
        });
        let csvContent = headers.join(',') + '\n';
        rows.forEach(row => {
            csvContent += row.join(',') + '\n';
        });
        return csvContent;
    }
    // Download file
    function downloadFile(content, fileName, contentType) {
        const a = document.createElement('a');
        const file = new Blob([content], { type: contentType });
        a.href = URL.createObjectURL(file);
        a.download = fileName;
        a.click();
        URL.revokeObjectURL(a.href);
    }
    // Check for expired vouchers (runs daily)
    function checkExpiredVouchers() {
        const today = new Date();
        let hasChanges = false;
        voucherData.forEach(voucher => {
            const expiryParts = voucher.expiry.split('/');
            const expiryDate = new Date(
                parseInt(expiryParts[2]), // year
                parseInt(expiryParts[1]) - 1, // month (0-based)
                parseInt(expiryParts[0]) // day
            );
            if (voucher.status === 'active' && expiryDate < today) {
                voucher.status = 'expired';
                hasChanges = true;
            }
        });
        if (hasChanges) {
            saveVoucherData();
            updateVoucherTable();
            updateStats();
        }
    }
    // Set up expiry check daily
    setInterval(checkExpiredVouchers, 24 * 60 * 60 * 1000);
    // Initial check
    checkExpiredVouchers();
    // Set today's date as the default expiry date (7 days from now)
    const defaultExpiryDate = new Date();
    defaultExpiryDate.setDate(defaultExpiryDate.getDate() + 7);
    const formattedExpiry = defaultExpiryDate.toISOString().split('T')[0];
    document.getElementById('expiry-date').value = formattedExpiry;
    // Auto-focus username field
    if (username) {
        username.focus();
    }
    // Custom Popup Functions
    function showCustomAlert(message, type = 'success', title = '') {
        return new Promise((resolve) => {
            // Remove existing popup
            const existingPopup = document.querySelector('.custom-popup-overlay');
            if (existingPopup) {
                existingPopup.remove();
            }
            // Prevent body scroll
            document.body.classList.add('popup-open');
            // Set default titles
            if (!title) {
                switch(type) {
                    case 'success': title = 'Berhasil!'; break;
                    case 'error': title = 'Error!'; break;
                    case 'warning': title = 'Peringatan!'; break;
                    default: title = 'Informasi'; break;
                }
            }
            // Set icon based on type
            let icon = 'fas fa-check';
            switch(type) {
                case 'error': icon = 'fas fa-exclamation-triangle'; break;
                case 'warning': icon = 'fas fa-exclamation-circle'; break;
                case 'success': icon = 'fas fa-check-circle'; break;
                default: icon = 'fas fa-info-circle'; break;
            }
            // Create popup HTML
            const popupHTML = `
                <div class="custom-popup-overlay">
                    <div class="custom-popup">
                        <div class="custom-popup-icon ${type}">
                            <i class="${icon}"></i>
                        </div>
                        <div class="custom-popup-title">${title}</div>
                        <div class="custom-popup-message">${message}</div>
                        <div class="custom-popup-buttons">
                            <button class="custom-popup-btn primary" onclick="closeCustomPopup()">
                                <i class="fas fa-check"></i> OK
                            </button>
                        </div>
                    </div>
                </div>
            `;
            // Add to body
            document.body.insertAdjacentHTML('beforeend', popupHTML);
            // Show popup with animation
            const popup = document.querySelector('.custom-popup-overlay');
            setTimeout(() => {
                popup.classList.add('show');
            }, 10);
            // Auto close after 3 seconds for success messages
            if (type === 'success') {
                setTimeout(() => {
                    closeCustomPopup();
                    resolve(true);
                }, 3000);
            }
            // Store resolve function for manual close
            window.customPopupResolve = resolve;
        });
    }
    function showCustomConfirm(message, title = 'Konfirmasi') {
        return new Promise((resolve) => {
            // Remove existing popup
            const existingPopup = document.querySelector('.custom-popup-overlay');
            if (existingPopup) {
                existingPopup.remove();
            }
            // Prevent body scroll
            document.body.classList.add('popup-open');
            // Create popup HTML
            const popupHTML = `
                <div class="custom-popup-overlay">
                    <div class="custom-popup">
                        <div class="custom-popup-icon warning">
                            <i class="fas fa-question-circle"></i>
                        </div>
                        <div class="custom-popup-title">${title}</div>
                        <div class="custom-popup-message">${message}</div>
                        <div class="custom-popup-buttons">
                            <button class="custom-popup-btn secondary" onclick="closeCustomPopup(false)">
                                <i class="fas fa-times"></i> Batal
                            </button>
                            <button class="custom-popup-btn primary" onclick="closeCustomPopup(true)">
                                <i class="fas fa-check"></i> Ya
                            </button>
                        </div>
                    </div>
                </div>
            `;
            // Add to body
            document.body.insertAdjacentHTML('beforeend', popupHTML);
            // Show popup with animation
            const popup = document.querySelector('.custom-popup-overlay');
            setTimeout(() => {
                popup.classList.add('show');
            }, 10);
            // Store resolve function
            window.customPopupResolve = resolve;
        });
    }
    function closeCustomPopup(result = true) {
        const popup = document.querySelector('.custom-popup-overlay');
        if (popup) {
            popup.classList.remove('show');
            // Restore body scroll
            document.body.classList.remove('popup-open');
            setTimeout(() => {
                popup.remove();
                if (window.customPopupResolve) {
                    window.customPopupResolve(result);
                    window.customPopupResolve = null;
                }
            }, 300);
        }
    }
    // Make functions global
    window.closeCustomPopup = closeCustomPopup;
});