<?php
session_start();
require_once 'config/database.php';
header('Content-Type: application/json');
if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    http_response_code(405);
    echo json_encode(['success' => false, 'message' => 'Method not allowed']);
    exit;
}
$input = json_decode(file_get_contents('php://input'), true);
// Handle logout action
if (isset($input['action']) && $input['action'] === 'logout') {
    handleLogout();
    exit;
}
// Handle login
$username = trim($input['username'] ?? '');
$password = $input['password'] ?? '';
$ip_address = $_SERVER['REMOTE_ADDR'];
// Validasi input
if (empty($username) || empty($password)) {
    echo json_encode(['success' => false, 'message' => 'Username dan password harus diisi']);
    exit;
}
try {
    // Find user
    $stmt = $pdo->prepare("
        SELECT id, username, password, email, full_name, role, status
        FROM admin_users
        WHERE username = ? AND status = 'active'
    ");
    $stmt->execute([$username]);
    $user = $stmt->fetch();
    if ($user && password_verify($password, $user['password'])) {
        // Generate session token
        $sessionToken = bin2hex(random_bytes(32));
        $expiresAt = date('Y-m-d H:i:s', strtotime('+24 hours'));
        // Save session
        $stmt = $pdo->prepare("
            INSERT INTO admin_sessions (user_id, session_token, expires_at)
            VALUES (?, ?, ?)
        ");
        $stmt->execute([$user['id'], $sessionToken, $expiresAt]);
        // Update last login
        $stmt = $pdo->prepare("UPDATE admin_users SET last_login = NOW() WHERE id = ?");
        $stmt->execute([$user['id']]);
        // Set session variables
        $_SESSION['admin_logged_in'] = true;
        $_SESSION['admin_id'] = $user['id'];
        $_SESSION['admin_username'] = $user['username'];
        $_SESSION['admin_role'] = $user['role'];
        $_SESSION['session_token'] = $sessionToken;
        // Set secure cookie
        setcookie('admin_token', $sessionToken, time() + 86400, '/', '', false, true); // HttpOnly
        echo json_encode([
            'success' => true,
            'message' => 'Login berhasil',
            'data' => [
                'username' => $user['username'],
                'full_name' => $user['full_name'],
                'role' => $user['role']
            ]
        ]);    } else {
        echo json_encode(['success' => false, 'message' => 'Username atau password salah']);
    }
} catch (PDOException $e) {
    error_log("Login error: " . $e->getMessage());
    echo json_encode(['success' => false, 'message' => 'Terjadi kesalahan sistem']);
}
function handleLogout() {
    global $pdo;
    try {
        // Delete session from database if exists
        if (isset($_SESSION['session_token'])) {
            $stmt = $pdo->prepare("DELETE FROM admin_sessions WHERE session_token = ?");
            $stmt->execute([$_SESSION['session_token']]);
        }
        // Clear session
        session_unset();
        session_destroy();
        // Clear cookie
        if (isset($_COOKIE['admin_token'])) {
            setcookie('admin_token', '', time() - 3600, '/', '', false, true);
        }
        echo json_encode(['success' => true, 'message' => 'Logout berhasil']);
    } catch (PDOException $e) {
        error_log("Logout error: " . $e->getMessage());
        echo json_encode(['success' => true, 'message' => 'Logout berhasil']); // Still success for user
    }
}
?>
