<?php
header('Content-Type: application/json');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: POST');
header('Access-Control-Allow-Headers: Content-Type');
require_once 'config/database.php';
if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    http_response_code(405);
    echo json_encode(['success' => false, 'message' => 'Method not allowed']);
    exit;
}
$input = json_decode(file_get_contents('php://input'), true);
$prizeName = $input['prize_name'];
$name = isset($input['name']) ? $input['name'] : null; // Ambil nama user jika ada
if (!$input || !isset($input['prize_name'])) {
    http_response_code(400);
    echo json_encode(['success' => false, 'message' => 'Invalid input data']);
    exit;
}
try {
    $pdo->beginTransaction();
    $currentDate = date('Y-m-d');
    $currentTime = date('H:i:s');
    // Tentukan tipe hadiah
    $prizeType = 'jackpot';
    if (strtolower(trim($prizeName)) === 'zonk' || strtolower(trim($prizeName)) === 'coba lagi') {
        $prizeType = 'try_again';
    }
    // Insert ke tabel spins (tambahkan kolom name)
    $stmt = $pdo->prepare("
        INSERT INTO lucky_wheel_spins (name, prize_name, prize_type, spin_date, spin_time)
        VALUES (?, ?, ?, ?, ?)
    ");
    $stmt->execute([$name, $prizeName, $prizeType, $currentDate, $currentTime]);
    // Update atau insert statistik harian
    $updateDaily = $pdo->prepare("
        INSERT INTO lucky_wheel_daily_stats (
            stat_date, total_spins, total_prizes_claimed,
            jackpot_count, cash_prizes_count, bonus_count,
            voucher_prizes_count, try_again_count
        ) VALUES (?, 1, ?, ?, ?, ?, ?, ?)
        ON DUPLICATE KEY UPDATE
            total_spins = total_spins + 1,
            total_prizes_claimed = total_prizes_claimed + ?,
            jackpot_count = jackpot_count + ?,
            cash_prizes_count = cash_prizes_count + ?,
            bonus_count = bonus_count + ?,
            voucher_prizes_count = voucher_prizes_count + ?,
            try_again_count = try_again_count + ?
    ");
    $prizesClaimed = ($prizeType !== 'try_again') ? 1 : 0;
    $jackpotCount = ($prizeType === 'jackpot') ? 1 : 0;
    $cashCount = ($prizeType === 'cash') ? 1 : 0;
    $bonusCount = ($prizeType === 'bonus') ? 1 : 0;
    $voucherCount = ($prizeType === 'voucher') ? 1 : 0;
    $tryAgainCount = ($prizeType === 'try_again') ? 1 : 0;
    $updateDaily->execute([
        $currentDate, $prizesClaimed, $jackpotCount, $cashCount,
        $bonusCount, $voucherCount, $tryAgainCount,
        $prizesClaimed, $jackpotCount, $cashCount,
        $bonusCount, $voucherCount, $tryAgainCount
    ]);
    $pdo->commit();
    echo json_encode([
        'success' => true,
        'message' => 'Spin data saved successfully',
        'data' => [
            'prize_name' => $prizeName,
            'prize_type' => $prizeType,
            'date' => $currentDate,
            'time' => $currentTime
        ]
    ]);
} catch (PDOException $e) {
    $pdo->rollBack();
    http_response_code(500);
    echo json_encode([
        'success' => false,
        'message' => 'Database error: ' . $e->getMessage()
    ]);
}
?>
