<?php
// Create admin user with correct password hash
require_once 'config/database.php';
echo "<h2>Create Admin User</h2>";
try {
    // Delete existing admin user if exists
    $stmt = $pdo->prepare("DELETE FROM admin_users WHERE username = 'admin'");
    $stmt->execute();
    echo "<p style='color: orange;'>→ Existing admin user deleted (if any)</p>";
    // Create new admin user with correct password hash
    $username = 'admin';
    $password = 'admin123';
    $hashedPassword = password_hash($password, PASSWORD_DEFAULT);
    $stmt = $pdo->prepare("
        INSERT INTO admin_users (username, password, email, full_name, role, status)
        VALUES (?, ?, ?, ?, ?, ?)
    ");
    $result = $stmt->execute([
        $username,
        $hashedPassword,
        'admin@luckywheel.com',
        'Administrator',
        'super_admin',
        'active'
    ]);
    if ($result) {
        echo "<p style='color: green;'>✓ Admin user created successfully!</p>";
        // Test password verification
        if (password_verify($password, $hashedPassword)) {
            echo "<p style='color: green;'>✓ Password hash verification test: PASSED</p>";
        } else {
            echo "<p style='color: red;'>✗ Password hash verification test: FAILED</p>";
        }
        echo "<div style='background: #f0f8ff; padding: 15px; border-left: 4px solid #007bff; margin: 20px 0;'>";
        echo "<h3>Login Credentials:</h3>";
        echo "<ul>";
        echo "<li><strong>Username:</strong> admin</li>";
        echo "<li><strong>Password:</strong> admin123</li>";
        echo "</ul>";
        echo "<p>You can now login at: <a href='index.html'>index.html</a></p>";
        echo "</div>";
    } else {
        echo "<p style='color: red;'>✗ Failed to create admin user</p>";
    }
} catch (PDOException $e) {
    echo "<p style='color: red;'>✗ Database error: " . $e->getMessage() . "</p>";
}
?>
