-- Lucky Wheel: users table for multi-user spin system
CREATE TABLE IF NOT EXISTS users (
    id INT AUTO_INCREMENT PRIMARY KEY,
    username VARCHAR(100) NOT NULL UNIQUE,
    password VARCHAR(255),
    email VARCHAR(255),
    full_name VARCHAR(255),
    spin_chance INT DEFAULT 0,
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP
);

-- Example: add a test user with 0 spin chance
INSERT INTO users (username, password, email, full_name, spin_chance) VALUES ('testuser', '', 'test@luckywheel.com', 'Test User', 0)
ON DUPLICATE KEY UPDATE email=VALUES(email);
