<?php
// CORS Security - Protect from unauthorized access
require_once '../../config/cors-security.php';
CorsManager::setSecureHeaders();
CorsManager::handlePreflightRequest();

// Include production config for proper error handling
require_once '../../config/production.php';

header('Content-Type: application/json');
require_once __DIR__ . '/../config/database.php';
try {
    $stmt = $pdo->query("SELECT code, name, prize_name, status, expiry_date, created_at FROM vouchers ORDER BY created_at DESC LIMIT 100");
    $vouchers = $stmt->fetchAll(PDO::FETCH_ASSOC);
    echo json_encode([
        'success' => true,
        'vouchers' => $vouchers
    ]);
} catch (Exception $e) {
    http_response_code(500);
    echo json_encode([
        'success' => false,
        'message' => 'Error fetching vouchers: ' . $e->getMessage()
    ]);
}
?>
