<?php
// CORS Security - Protect from unauthorized access
require_once '../../config/cors-security.php';
CorsManager::setSecureHeaders();
CorsManager::handlePreflightRequest();

// Include production config
require_once '../../config/production.php';

header('Content-Type: application/json');
header('Access-Control-Allow-Methods: GET');
require_once __DIR__ . '/../config/database.php';
try {
    // Get voucher statistics
    $stats = [];
    // Total vouchers
    $stmt = $pdo->query("SELECT COUNT(*) as total FROM vouchers");
    $stats['total'] = $stmt->fetch(PDO::FETCH_ASSOC)['total'];
    // Active vouchers (not used and not expired)
    $stmt = $pdo->query("
        SELECT COUNT(*) as active
        FROM vouchers
        WHERE is_used = FALSE
        AND expiry_date > CURDATE()
        AND used_count < usage_limit
    ");
    $stats['active'] = $stmt->fetch(PDO::FETCH_ASSOC)['active'];
    // Used vouchers
    $stmt = $pdo->query("
        SELECT COUNT(*) as used
        FROM vouchers
        WHERE is_used = TRUE OR used_count >= usage_limit
    ");
    $stats['used'] = $stmt->fetch(PDO::FETCH_ASSOC)['used'];
    // Expired vouchers
    $stmt = $pdo->query("
        SELECT COUNT(*) as expired
        FROM vouchers
        WHERE expiry_date <= CURDATE()
        AND is_used = FALSE
    ");
    $stats['expired'] = $stmt->fetch(PDO::FETCH_ASSOC)['expired'];
    // Pending vouchers
    $stmt = $pdo->query("
        SELECT COUNT(*) as pending
        FROM vouchers
        WHERE status = 'pending'
    ");
    $stats['pending'] = $stmt->fetch(PDO::FETCH_ASSOC)['pending'];
    // Claimed vouchers
    $stmt = $pdo->query("
        SELECT COUNT(*) as claimed
        FROM vouchers
        WHERE status = 'claim' OR status = 'claimed'
    ");
    $stats['claimed'] = $stmt->fetch(PDO::FETCH_ASSOC)['claimed'];
    echo json_encode([
        'success' => true,
        'stats' => $stats
    ]);
} catch (Exception $e) {
    http_response_code(500);
    echo json_encode([
        'success' => false,
        'message' => 'Error fetching voucher stats: ' . $e->getMessage()
    ]);
}
?>
