<?php
// CORS Security - Protect from unauthorized access
require_once '../../config/cors-security.php';
CorsManager::setSecureHeaders();
CorsManager::handlePreflightRequest();

// Include production config
require_once '../../config/production.php';

header('Content-Type: application/json');
header('Access-Control-Allow-Methods: GET');
require_once 'config/database.php';
try {
    $limit = isset($_GET['limit']) ? intval($_GET['limit']) : 10;
    $offset = isset($_GET['offset']) ? intval($_GET['offset']) : 0;
    // Get recent vouchers
    $stmt = $pdo->prepare("
        SELECT id, code, type, value, prefix, expiry_date, usage_limit, used_count, is_used, created_at, created_by
        FROM vouchers
        ORDER BY created_at DESC
        LIMIT ? OFFSET ?
    ");
    $stmt->execute([$limit, $offset]);
    $vouchers = $stmt->fetchAll(PDO::FETCH_ASSOC);
    // Format the data
    $formattedVouchers = array_map(function($voucher) {
        return [
            'id' => $voucher['id'],
            'code' => $voucher['code'],
            'type' => $voucher['type'],
            'value' => floatval($voucher['value']),
            'prefix' => $voucher['prefix'],
            'expiryDate' => $voucher['expiry_date'],
            'usageLimit' => intval($voucher['usage_limit']),
            'usedCount' => intval($voucher['used_count']),
            'used' => (bool)$voucher['is_used'],
            'createdAt' => $voucher['created_at'],
            'createdBy' => $voucher['created_by'],
            'status' => getVoucherStatus($voucher)
        ];
    }, $vouchers);
    echo json_encode([
        'success' => true,
        'vouchers' => $formattedVouchers
    ]);
} catch (Exception $e) {
    http_response_code(500);
    echo json_encode([
        'success' => false,
        'message' => 'Error fetching vouchers: ' . $e->getMessage()
    ]);
}
function getVoucherStatus($voucher) {
    $now = date('Y-m-d');
    if ($voucher['is_used'] || $voucher['used_count'] >= $voucher['usage_limit']) {
        return 'used';
    } else if ($voucher['expiry_date'] <= $now) {
        return 'expired';
    } else {
        return 'active';
    }
}
?>
