<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Generate Voucher - Lucky Wheel Admin</title>
    <link rel="stylesheet" href="../css/admin.css">
    <link rel="stylesheet" href="../dashboard/css/dashboard.css">
    <link rel="stylesheet" href="../dashboard/css/dashboard-layout.css">
    <link rel="stylesheet" href="../dashboard/css/dashboard-widgets.css">
    <!-- Font Awesome -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
    <!-- AOS Animation -->
    <link href="https://unpkg.com/aos@2.3.1/dist/aos.css" rel="stylesheet">
    <!-- Custom CSS for voucher functionality -->
    <link rel="stylesheet" href="css/vouchers-custom.css">
</head>
<body>
    <div class="admin-container">
        <!-- Progress Loading Bar -->
        <div class="loading-bar">
            <div class="loading-progress"></div>
        </div>
        
        <header class="admin-header">
            <div class="header-left">
                <div class="logo">
                    <img src="../../assets/img/logo-lembagatoto.webp" alt="Lucky Wheel Logo">
                </div>
                <div class="header-info">
                    <h1>Manajemen Voucher</h1>
                    <p class="header-subtitle">Generate & Kelola Voucher Lucky Wheel</p>
                </div>
            </div>
            <div class="header-actions">
                <div class="weather-widget">
                    <i class="fas fa-sun"></i>
                    <span>28°C</span>
                </div>
                <span class="date-display" id="live-date">25 Juni 2025</span>
                <button class="header-btn refresh-btn" title="Refresh Data"><i class="fas fa-sync-alt"></i></button>
                <button class="header-btn notifications-btn" title="Notifikasi"><i class="fas fa-bell"></i><span class="notification-badge">3</span></button>
                <div class="user-profile">
                    <img src="../../assets/img/favicon.ico" alt="Admin" class="profile-avatar">
                    <span class="profile-name">Admin</span>
                </div>
            </div>
        </header>

        <div class="dashboard-container">
            <div class="admin-sidebar">
                <nav class="admin-nav">
                    <ul>
                        <li><a href="../dashboard/index.html"><i class="fas fa-tachometer-alt"></i> <span>Dashboard</span></a></li>
                        <li class="active"><a href="index.html"><i class="fas fa-ticket-alt"></i> <span>Voucher</span></a></li>
                        <li><a href="../hadiah/index.html"><i class="fas fa-gift"></i> <span>Hadiah</span></a></li>
                        <li><a href="../pengguna/index.html"><i class="fas fa-users"></i> <span>Pemenang</span></a></li>
                        <li><a href="#"><i class="fas fa-chart-bar"></i> <span>Statistik</span></a></li>
                        <li><a href="#"><i class="fas fa-cog"></i> <span>Pengaturan</span></a></li>
                    </ul>
                </nav>
                <div class="admin-user">
                    <div class="user-avatar">
                        <i class="fas fa-user-circle"></i>
                    </div>
                    <div class="user-info">
                        <p class="user-name">Admin</p>
                        <button id="logout-btn" class="small-btn"><i class="fas fa-sign-out-alt"></i> Logout</button>
                    </div>
                </div>
            </div>

            <div class="dashboard-content">
                <!-- Page Header -->
                <div class="page-header" data-aos="fade-down">
                    <div class="page-title">
                        <h2><i class="fas fa-ticket-alt"></i> Generate Voucher</h2>
                        <p>Buat dan kelola voucher untuk Lucky Wheel</p>
                    </div>
                    <div class="page-actions">
                        <button class="action-btn success" id="bulk-generate-btn">
                            <i class="fas fa-layer-group"></i>
                            <span>Generate Bulk</span>
                        </button>
                        <button class="action-btn secondary" id="export-vouchers-main-btn">
                            <i class="fas fa-download"></i>
                            <span>Export Voucher</span>
                        </button>
                    </div>
                </div>

                <!-- Quick Stats -->
                <div class="voucher-stats-section" data-aos="fade-up">
                    <div class="stats-row">
                        <div class="stat-card">
                            <div class="stat-icon blue">
                                <i class="fas fa-ticket-alt"></i>
                            </div>
                            <div class="stat-details">
                                <h4>Total Voucher</h4>
                                <p class="stat-number" id="total-vouchers">0</p>
                            </div>
                        </div>
                        <div class="stat-card">
                            <div class="stat-icon green">
                                <i class="fas fa-check-circle"></i>
                            </div>
                            <div class="stat-details">
                                <h4>Voucher Aktif</h4>
                                <p class="stat-number" id="active-vouchers">0</p>
                            </div>
                        </div>
                        <div class="stat-card">
                            <div class="stat-icon orange">
                                <i class="fas fa-clock"></i>
                            </div>
                            <div class="stat-details">
                                <h4>Voucher Digunakan</h4>
                                <p class="stat-number" id="used-vouchers">0</p>
                            </div>
                        </div>
                        <div class="stat-card">
                            <div class="stat-icon red">
                                <i class="fas fa-times-circle"></i>
                            </div>
                            <div class="stat-details">
                                <h4>Voucher Expired</h4>
                                <p class="stat-number" id="expired-vouchers">0</p>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Generate Voucher Form -->
                <div class="content-grid">
                    <div class="generate-section" data-aos="fade-right">
                        <div class="section-card">
                            <div class="card-header">
                                <h3><i class="fas fa-plus-circle"></i> Generate Voucher Baru</h3>
                                <p>Buat voucher untuk Lucky Wheel</p>
                                <button type="button" class="small-btn secondary" id="refresh-prizes-btn" title="Refresh Data Hadiah">
                                    <i class="fas fa-sync-alt"></i> Refresh Hadiah
                                </button>
                            </div>
                            <div class="card-body">
                                <form id="generate-voucher-form">
                                    <div class="form-grid">
                                        <div class="form-group">
                                            <label for="name">Nama</label>
                                            <input type="text" id="name" class="form-control" placeholder="Masukkan nama..." required>
                                        </div>
                                        
                                        <div class="form-group">
                                            <label for="prize-type">Hadiah</label>
                                            <select id="prize-type" class="form-control" required>
                                                <option value="">Pilih Hadiah dari Roda</option>
                                            </select>
                                        </div>
                                        
                                        <div class="form-group">
                                            <label for="voucher-status">Status</label>
                                            <select id="voucher-status" class="form-control">
                                                <option value="pending">Pending</option>
                                                <option value="claim">Claim</option>
                                                <option value="menunggu claim">Menunggu Claim</option>
                                                <option value="expired">Expired</option>
                                            </select>
                                        </div>
                                        
                                        <div class="form-group">
                                            <label for="expiry-date">Tanggal Kadaluarsa</label>
                                            <input type="date" id="expiry-date" class="form-control" required>
                                        </div>
                                    </div>

                                    <div class="form-actions">
                                        <button type="submit" class="btn btn-primary">
                                            <i class="fas fa-plus"></i> Generate Voucher
                                        </button>
                                    </div>
                                </form>
                            </div>
                        </div>
                        <div class="section-card" id="voucher-db-list-section">
                            <div class="card-header">
                                <h3><i class="fas fa-database"></i> Daftar Voucher</h3>
                            </div>
                            <div class="card-body">
                                <!-- Filter langsung di atas tabel -->
                                <div class="voucher-search mb-16">
                                    <div class="search-controls">
                                        <input type="text" id="search-voucher" placeholder="Cari kode atau nama..." class="form-control">
                                        <select id="filter-status" class="form-control" title="Filter berdasarkan status voucher">
                                            <option value="">Semua Status</option>
                                            <option value="pending">Pending</option>
                                            <option value="claim">Claim</option>
                                            <option value="menunggu claim">Menunggu Claim</option>
                                            <option value="expired">Expired</option>
                                        </select>
                                    </div>
                                </div>
                                <div class="voucher-db-list-wrapper">
                                    <table class="voucher-db-table">
                                        <thead>
                                            <tr>
                                                <th>Kode</th>
                                                <th>Nama</th>
                                                <th>Hadiah</th>
                                                <th>Kadaluarsa</th>
                                                <th>Dibuat</th>
                                                <th>Status</th>
                                                <th>Aksi</th> <!-- Kolom untuk tombol Edit -->
                                            </tr>
                                        </thead>
                                        <tbody id="voucher-db-list">
                                            <tr class="loading-row"><td colspan="7">Memuat data...</td></tr>
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>

                        <!-- Modal Edit Voucher -->
                        <div id="edit-voucher-modal" class="modal-overlay hidden">
                            <div class="modal-card edit-modal-card animate-pop" tabindex="-1">
                                <button class="close-modal-btn" id="close-edit-modal" title="Tutup">&times;</button>
                                <h3 class="modal-title"><i class="fas fa-edit"></i> Edit Voucher</h3>
                                <form id="edit-voucher-form" autocomplete="off">
                                    <input type="hidden" id="edit-voucher-id">
                                    <div class="form-group">
                                        <label for="edit-name">Nama Penerima</label>
                                        <input type="text" id="edit-name" class="form-control" required autocomplete="off" placeholder="Nama penerima voucher">
                                    </div>
                                    <div class="form-group">
                                        <label for="edit-prize">Hadiah</label>
                                        <select id="edit-prize" class="form-control" required></select>
                                        <div id="edit-prize-error" class="edit-prize-error"></div>
                                    </div>
                                    <div class="form-group">
                                        <label for="edit-status">Status</label>
                                        <select id="edit-status" class="form-control">
                                            <option value="pending">Pending</option>
                                            <option value="claim">Claim</option>
                                            <option value="menunggu claim">Menunggu Claim</option>
                                            <option value="expired">Expired</option>
                                        </select>
                                    </div>
                                    <div class="form-group">
                                        <label for="edit-expiry">Tanggal Kadaluarsa</label>
                                        <input type="date" id="edit-expiry" class="form-control" required>
                                    </div>
                                    <button type="submit" class="action-btn success full-width" id="edit-save-btn"><i class="fas fa-save"></i> Simpan Perubahan</button>
                                </form>
                            </div>
                        </div>
                    </div>

                    <!-- Recent Vouchers & Management -->
                    <div class="section-card">
                        <div class="card-header">
                            <h3><i class="fas fa-list"></i> Manajemen Voucher</h3>
                            <p>Kelola dan pantau voucher yang sudah dibuat</p>
                        </div>
                        <div class="card-body">
                            <!-- Stats Section -->
                            <div class="voucher-stats" id="voucher-stats">
                                <div class="stat-card stat-pending">
                                    <div class="stat-number" id="stat-pending">0</div>
                                    <div class="stat-label">Pending</div>
                                </div>
                                <div class="stat-card stat-claimed">
                                    <div class="stat-number" id="stat-claimed">0</div>
                                    <div class="stat-label">Claimed</div>
                                </div>
                                <div class="stat-card stat-expired">
                                    <div class="stat-number" id="stat-expired">0</div>
                                    <div class="stat-label">Expired</div>
                                </div>
                                <div class="stat-card stat-total">
                                    <div class="stat-number" id="stat-total">0</div>
                                    <div class="stat-label">Total</div>
                                </div>
                            </div>

                            <!-- Quick Actions -->
                            <div class="quick-actions">
                                <button class="quick-btn" id="refresh-stats-btn">
                                    <i class="fas fa-sync-alt"></i> Refresh
                                </button>
                                <button class="quick-btn" id="export-vouchers-quick-btn">
                                    <i class="fas fa-download"></i> Export
                                </button>
                                <button class="quick-btn" id="clear-expired-btn">
                                    <i class="fas fa-trash"></i> Clear Expired
                                </button>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Custom success popup for voucher generation -->
    <div class="voucher-success-popup hidden">
        <div class="voucher-success-content">
            <div class="voucher-success-header">
                <h3>✅ Voucher Berhasil Dibuat!</h3>
                <button class="close-voucher-success">&times;</button>
            </div>
            <div class="voucher-success-body">
                <p><strong>Detail Voucher:</strong></p>
                <p>👤 Nama: <span id="success-winner-name"></span></p>
                <p>🎁 Hadiah: <span id="success-prize-text"></span></p>
                <p>📅 Tanggal Kadaluarsa: <span id="success-expiry-date"></span></p>
                <p>📊 Status: <span class="status-badge" id="success-status-badge"></span></p>
                <p>🎫 Kode Voucher: <strong id="success-voucher-code"></strong></p>
            </div>
            <div class="voucher-success-footer">
                <button class="btn-primary" id="copy-success-code">
                    <i class="fas fa-copy"></i> Salin Kode
                </button>
                <button class="btn-secondary" id="close-success-popup">
                    <i class="fas fa-check"></i> Tutup
                </button>
            </div>
        </div>
    </div>

    <!-- Custom Confirm Delete Popup -->
    <div class="voucher-confirm-delete-popup hidden" id="voucher-confirm-delete-popup">
        <div class="voucher-confirm-content">
            <div class="voucher-confirm-header">
                <h3><i class="fas fa-exclamation-triangle"></i> Konfirmasi Hapus Voucher</h3>
                <button class="close-confirm-delete" id="close-confirm-delete">&times;</button>
            </div>
            <div class="voucher-confirm-body">
                <p>Yakin ingin menghapus voucher untuk <strong id="confirm-delete-name">-</strong>?</p>
                <p class="confirm-delete-code">Kode: <span id="confirm-delete-code">-</span></p>
                <div class="confirm-delete-error" id="confirm-delete-error"></div>
            </div>
            <div class="voucher-confirm-footer">
                <button class="btn-secondary" id="cancel-delete-btn"><i class="fas fa-times"></i> Batal</button>
                <button class="btn-danger" id="confirm-delete-btn"><i class="fas fa-trash"></i> Hapus</button>
            </div>
        </div>
    </div>

    <!-- AOS Animation -->
    <script src="https://unpkg.com/aos@2.3.1/dist/aos.js"></script>
    <script src="js/vouchers-admin.js"></script>
    <script src="js/vouchers-management.js"></script>
    <script src="js/vouchers-form.js"></script>
    <script>
    // Definisi fungsi custom modal untuk vouchers
    function showCustomConfirm(message, title = 'Konfirmasi') {
        return new Promise((resolve) => {
            // Remove existing popup
            const existingPopup = document.querySelector('.custom-popup-overlay');
            if (existingPopup) {
                existingPopup.remove();
            }
            
            // Prevent body scroll
            document.body.classList.add('popup-open');
            
            // Create popup HTML
            const popupHTML = `
                <div class="custom-popup-overlay">
                    <div class="custom-popup">
                        <div class="custom-popup-icon warning">
                            <i class="fas fa-question-circle"></i>
                        </div>
                        <div class="custom-popup-title">${title}</div>
                        <div class="custom-popup-message">${message}</div>
                        <div class="custom-popup-buttons">
                            <button class="custom-popup-btn secondary" onclick="closeCustomPopup(false)">
                                <i class="fas fa-times"></i> Batal
                            </button>
                            <button class="custom-popup-btn primary" onclick="closeCustomPopup(true)">
                                <i class="fas fa-check"></i> Ya
                            </button>
                        </div>
                    </div>
                </div>
            `;
            
            // Add to body
            document.body.insertAdjacentHTML('beforeend', popupHTML);
            
            // Show popup with animation
            const popup = document.querySelector('.custom-popup-overlay');
            setTimeout(() => {
                popup.classList.add('show');
            }, 10);
            
            // Store resolve function
            window.customPopupResolve = resolve;
        });
    }
    
    function closeCustomPopup(result = true) {
        const popup = document.querySelector('.custom-popup-overlay');
        if (popup) {
            popup.classList.remove('show');
            // Restore body scroll
            document.body.classList.remove('popup-open');
            setTimeout(() => {
                popup.remove();
                if (window.customPopupResolve) {
                    window.customPopupResolve(result);
                    window.customPopupResolve = null;
                }
            }, 300);
        }
    }
    
    // Make functions global
    window.showCustomConfirm = showCustomConfirm;
    window.closeCustomPopup = closeCustomPopup;
    
    // Universal logout handler untuk vouchers
    document.addEventListener('DOMContentLoaded', function() {
        const logoutBtn = document.getElementById('logout-btn');
        if (logoutBtn && !logoutBtn.hasAttribute('data-logout-attached')) {
            logoutBtn.addEventListener('click', async function(event) {
                event.preventDefault();
                
                // Menggunakan showCustomConfirm jika tersedia
                let confirmed = false;
                if (typeof showCustomConfirm === 'function') {
                    confirmed = await showCustomConfirm('Apakah Anda yakin ingin keluar?', 'Konfirmasi Logout');
                } else {
                    confirmed = confirm('Apakah Anda yakin ingin keluar?');
                }
                
                if (!confirmed) return;
                
                try {
                    // Panggil endpoint logout untuk membersihkan session
                    await fetch('../login.php', {
                        method: 'POST',
                        headers: {
                            'Content-Type': 'application/json',
                            'X-Requested-With': 'XMLHttpRequest'
                        },
                        body: JSON.stringify({
                            action: 'logout'
                        })
                    });
                } catch (error) {
                    console.error('Logout error:', error);
                }
                
                // Redirect ke halaman login
                window.location.href = '../index.html';
            });
            
            logoutBtn.setAttribute('data-logout-attached', '1');
        }
    });
    </script>
</body>
</html>
