// Vouchers Management JavaScript
// Set default expiry date (30 days from now) saat halaman siap
// dan update tanggal live di header jika ada
document.addEventListener('DOMContentLoaded', function() {
    // Set tanggal kadaluarsa default
    const expiryDate = new Date();
    expiryDate.setDate(expiryDate.getDate() + 30);
    const expiryInput = document.getElementById('expiry-date');
    if (expiryInput) {
        expiryInput.value = expiryDate.toISOString().split('T')[0];
    }
    // Update tanggal live jika ada elemen dengan id live-date
    const liveDate = document.getElementById('live-date');
    if (liveDate) {
        const currentDate = new Date();
        const options = { day: 'numeric', month: 'long', year: 'numeric' };
        liveDate.textContent = currentDate.toLocaleDateString('id-ID', options);
    }
});