// === CRUD Voucher Admin Panel ===
document.addEventListener('DOMContentLoaded', function() {
    // Load prizes data for dropdown
    if (window.loadPrizesData) window.loadPrizesData();
    // Load daftar voucher dari database dan render ke tabel
    async function loadVoucherDbList() {
        const tbody = document.getElementById('voucher-db-list');
        if (!tbody) return;
        tbody.innerHTML = '<tr><td colspan="5" class="empty-row">Memuat data...</td></tr>';
        try {
            const res = await fetch('get-all-vouchers.php');
            const data = await res.json();
            if (data.success && data.vouchers && data.vouchers.length > 0) {
                tbody.innerHTML = data.vouchers.map(v => `
                    <tr>
                        <td>${v.code}</td>
                        <td>${v.name || '-'}</td>
                        <td>${v.prize_name || '-'}</td>
                        <td>${v.expiry_date || '-'}</td>
                        <td>${v.created_at || '-'}</td>
                        <td><span class="status-badge ${v.status}">${v.status ? v.status.charAt(0).toUpperCase() + v.status.slice(1) : '-'}</span></td>
                        <td>
                            <div class="voucher-action-group">
                                <button 
                                    class="edit-voucher-btn action-btn secondary" 
                                    title="Edit Voucher" 
                                    data-id="${v.code}"
                                    data-name="${v.name || ''}"
                                    data-prize="${v.prize_name || ''}"
                                    data-status="${v.status || ''}"
                                    data-expiry="${v.expiry_date || ''}"
                                ><i class="fas fa-edit"></i></button>
                                <button 
                                    class="delete-voucher-btn action-btn danger" 
                                    title="Hapus Voucher" 
                                    data-id="${v.code}"
                                    data-name="${v.name || ''}"
                                ><i class="fas fa-trash"></i></button>
                            </div>
                        </td>
                    </tr>
                `).join('');
                // Tambahkan event listener untuk tombol edit
                setTimeout(() => {
                    document.querySelectorAll('.edit-voucher-btn').forEach(btn => {
                        btn.addEventListener('click', async function() {
                            try {
                                document.getElementById('edit-voucher-id').value = this.dataset.id;
                                document.getElementById('edit-name').value = this.dataset.name;
                                await populateEditPrizeDropdown(this.dataset.prize);
                                document.getElementById('edit-status').value = this.dataset.status;
                                document.getElementById('edit-expiry').value = this.dataset.expiry;
                                document.getElementById('edit-voucher-modal').style.display = 'flex';
                                document.getElementById('edit-voucher-modal').classList.remove('hidden');
                                setTimeout(() => {
                                    const card = document.querySelector('.edit-modal-card');
                                    if(card) card.focus();
                                    const firstInput = document.getElementById('edit-name');
                                    if(firstInput) firstInput.focus();
                                }, 100);
                            } catch (err) {
                                alert('Terjadi error saat membuka form edit voucher. Lihat console untuk detail.');
                            }
                        });
                    });
                    // Event listener tombol hapus voucher
                    document.querySelectorAll('.delete-voucher-btn').forEach(btn => {
                        btn.addEventListener('click', function() {
                            const code = this.dataset.id;
                            const name = this.dataset.name;
                            showDeleteVoucherPopup(code, name);
                        });
                    });
                    document.getElementById('close-edit-modal').onclick = function() {
                        document.getElementById('edit-voucher-modal').style.display = 'none';
                    };
                    // UX: ESC untuk close modal
                    document.addEventListener('keydown', function escHandler(e) {
                        if (e.key === 'Escape' && document.getElementById('edit-voucher-modal').style.display !== 'none') {
                            document.getElementById('edit-voucher-modal').style.display = 'none';
                        }
                    });
                }, 100);
            } else {
                tbody.innerHTML = '<tr><td colspan="5" class="empty-row">Belum ada voucher di database</td></tr>';
            }
        } catch (e) {
            tbody.innerHTML = '<tr><td colspan="5" class="empty-row">Gagal memuat data</td></tr>';
        }
        // Panggil filter setelah data dimuat
        if (typeof filterVoucherDbList === 'function') filterVoucherDbList();
    }
    // Panggil saat halaman load
    if (document.getElementById('voucher-db-list')) {
        loadVoucherDbList();
    }
    // Update statistik voucher saat halaman load
    if (typeof window.updateVoucherStats === 'function') {
        try {
            window.updateVoucherStats();
        } catch (err) {
            if(document.getElementById('total-vouchers')) document.getElementById('total-vouchers').textContent = 'Err';
            if(document.getElementById('active-vouchers')) document.getElementById('active-vouchers').textContent = 'Err';
            if(document.getElementById('used-vouchers')) document.getElementById('used-vouchers').textContent = 'Err';
            if(document.getElementById('expired-vouchers')) document.getElementById('expired-vouchers').textContent = 'Err';
        }
    }
    // Fitur filter/pencarian daftar voucher database
    const searchInput = document.getElementById('search-voucher');
    const statusSelect = document.getElementById('filter-status');
    function filterVoucherDbList() {
        const search = (searchInput?.value || '').toLowerCase();
        const status = statusSelect?.value || '';
        const tbody = document.getElementById('voucher-db-list');
        if (!tbody) return;
        const rows = Array.from(tbody.querySelectorAll('tr'));
        rows.forEach(row => {
            // Skip loading/empty row
            if (row.classList.contains('loading-row') || row.classList.contains('empty-row')) return;
            const kode = (row.children[0]?.textContent || '').toLowerCase();
            const nama = (row.children[1]?.textContent || '').toLowerCase();
            const stat = (row.children[5]?.textContent || '').toLowerCase();
            const matchSearch = !search || kode.includes(search) || nama.includes(search);
            const matchStatus = !status || stat === status.toLowerCase();
            row.style.display = (matchSearch && matchStatus) ? '' : 'none';
        });
    }
    if (searchInput) searchInput.addEventListener('input', filterVoucherDbList);
    if (statusSelect) statusSelect.addEventListener('change', filterVoucherDbList);
    // Handler submit form edit voucher
    const editForm = document.getElementById('edit-voucher-form');
    if (editForm) {
        editForm.onsubmit = async function(e) {
            e.preventDefault();
            const saveBtn = document.getElementById('edit-save-btn');
            if(saveBtn) { saveBtn.disabled = true; saveBtn.innerHTML = '<i class="fas fa-spinner fa-spin"></i> Menyimpan...'; }
            const code = document.getElementById('edit-voucher-id').value;
            const name = document.getElementById('edit-name').value;
            const prize = document.getElementById('edit-prize').value;
            const status = document.getElementById('edit-status').value;
            const expiry = document.getElementById('edit-expiry').value;
            try {
                const res = await fetch('update-voucher.php', {
                    method: 'POST',
                    headers: { 'Content-Type': 'application/json' },
                    body: JSON.stringify({ code, name, prize_name: prize, status, expiry_date: expiry })
                });
                const data = await res.json();
                if (data.success) {
                    showCustomSuccessPopup('Voucher berhasil diupdate!');
                    document.getElementById('edit-voucher-modal').style.display = 'none';
                    loadVoucherDbList();
                } else {
                    alert('Gagal update voucher: ' + (data.message || 'Unknown error'));
                }
            } catch (err) {
                alert('Gagal update voucher: ' + err.message);
            } finally {
                if(saveBtn) { saveBtn.disabled = false; saveBtn.innerHTML = '<i class="fas fa-save"></i> Simpan Perubahan'; }
            }
        };
    }
    // Handler submit form generate voucher
    const generateForm = document.getElementById('generate-voucher-form');
    if (generateForm) {
        generateForm.addEventListener('submit', async function(e) {
            e.preventDefault();
            const submitBtn = this.querySelector('button[type="submit"]');
            if(submitBtn) { submitBtn.disabled = true; submitBtn.innerHTML = '<i class="fas fa-spinner fa-spin"></i> Menyimpan...'; }
            const name = document.getElementById('name').value.trim();
            const prizeSelect = document.getElementById('prize-type');
            const prizeKey = prizeSelect ? prizeSelect.value : '';
            const status = document.getElementById('voucher-status').value;
            const expiry = document.getElementById('expiry-date').value;
            if (!name || !prizeKey || !status || !expiry) {
                showCustomSuccessPopup('Semua field wajib diisi!');
                if(submitBtn) { submitBtn.disabled = false; submitBtn.innerHTML = '<i class=\'fas fa-plus\'></i> Generate Voucher'; }
                return;
            }
            // Ambil nama hadiah dari text option yang dipilih
            let prize_name = prizeSelect.options[prizeSelect.selectedIndex].textContent;
            if (prize_name === 'Pilih Hadiah dari Roda') prize_name = '';
            // Field tambahan default
            const type = 'discount'; // atau mapping dari hadiah jika mau
            const value = 1; // default, bisa diubah sesuai kebutuhan
            const count = 1; // default, bisa diubah sesuai kebutuhan
            const expiryDate = expiry; // camelCase sesuai backend
            // Kirim data sebagai JSON
            const payload = { name, prize_name, type, value, count, expiryDate, status };
            try {
                const res = await fetch('generate-vouchers.php', {
                    method: 'POST',
                    headers: { 'Content-Type': 'application/json' },
                    body: JSON.stringify(payload)
                });
                let data;
                try {
                    data = await res.json();
                } catch (jsonErr) {
                    const text = await res.text();
                    showCustomSuccessPopup('Gagal membuat voucher: Response backend tidak valid!');
                    throw new Error('Response backend tidak valid!');
                }
                if (!res.ok || !data.success) {
                    showCustomSuccessPopup('Gagal membuat voucher: ' + (data && data.message ? data.message : 'Unknown error'));
                    return;
                }
                // Ambil kode voucher terakhir dari response jika ada
                let lastCode = data.code || (data.codes && data.codes[0]) || null;
                // Tampilkan popup custom HTML bawaan
                showVoucherSuccessPopup({
                    name,
                    prize: prize_name,
                    expiry: expiryDate,
                    status,
                    code: lastCode || '-'
                });
                loadVoucherDbList();
                if (typeof window.updateVoucherStats === 'function') window.updateVoucherStats();
                this.reset();
            } catch (err) {
                showCustomSuccessPopup('Gagal membuat voucher: ' + (err && err.message ? err.message : err));
            } finally {
                if(submitBtn) { submitBtn.disabled = false; submitBtn.innerHTML = '<i class=\'fas fa-plus\'></i> Generate Voucher'; }
            }
        });
    }
    // Popup/modal edit voucher: close jika klik overlay
    const editModal = document.getElementById('edit-voucher-modal');
    if (editModal) {
        editModal.addEventListener('click', function(e) {
            if (e.target === editModal) {
                editModal.style.display = 'none';
            }
        });
    }
    // Custom popup sukses universal
    function showCustomSuccessPopup(message) {
        // Hapus popup lama jika ada
        const existing = document.querySelector('.custom-success-popup');
        if (existing) existing.remove();
        // Buat popup baru
        const popup = document.createElement('div');
        popup.className = 'custom-success-popup';
        popup.innerHTML = `
            <div class="custom-success-content">
                <div class="custom-success-icon"><i class="fas fa-check-circle"></i></div>
                <div class="custom-success-msg">${message}</div>
                <button class="custom-success-close" title="Tutup">&times;</button>
            </div>
        `;
        document.body.appendChild(popup);
        // Close handler
        popup.querySelector('.custom-success-close').onclick = () => popup.remove();
        // Klik overlay close
        popup.onclick = e => { if (e.target === popup) popup.remove(); };
        // Auto close
        setTimeout(() => { if (popup.parentNode) popup.remove(); }, 3000);
    }
    // Helper: isi select hadiah di modal edit
    async function populateEditPrizeDropdown(selectedPrize) {
        let prizes = window.availablePrizes || [];
        const select = document.getElementById('edit-prize');
        const errorDiv = document.getElementById('edit-prize-error');
        if (!select) return;
        select.innerHTML = '<option value="">Pilih Hadiah</option>';
        if (errorDiv) errorDiv.style.display = 'none';
        try {
            if (!prizes.length && window.loadPrizesData) {
                await window.loadPrizesData();
                prizes = window.availablePrizes || [];
            }
            if (!prizes.length) {
                const opt = document.createElement('option');
                opt.value = '';
                opt.textContent = 'Gagal memuat daftar hadiah';
                opt.disabled = true;
                select.appendChild(opt);
                select.disabled = false;
                if (errorDiv) {
                    errorDiv.textContent = 'Gagal memuat daftar hadiah dari server. Coba refresh halaman.';
                    errorDiv.style.display = 'block';
                }
                return;
            } else {
                select.disabled = false;
            }
            prizes.forEach(prize => {
                const opt = document.createElement('option');
                opt.value = prize.text;
                opt.textContent = prize.text;
                select.appendChild(opt);
            });
            if (selectedPrize) select.value = selectedPrize;
        } catch (err) {
            select.disabled = false;
            if (errorDiv) {
                errorDiv.textContent = 'Terjadi error saat memuat hadiah: ' + err.message;
                errorDiv.style.display = 'block';
            }
        }
    }
    // Helper: isi select hadiah di form generate voucher
    async function populatePrizeDropdown() {
        let prizes = window.availablePrizes || [];
        const select = document.getElementById('prize-type');
        if (!select) return;
        select.innerHTML = '<option value="">Pilih Hadiah dari Roda</option>';
        try {
            if (!prizes.length && window.loadPrizesData) {
                await window.loadPrizesData();
                prizes = window.availablePrizes || [];
            }
            if (!prizes.length) {
                const opt = document.createElement('option');
                opt.value = '';
                opt.textContent = 'Gagal memuat daftar hadiah';
                opt.disabled = true;
                select.appendChild(opt);
                select.disabled = false;
                return;
            } else {
                select.disabled = false;
            }
            prizes.forEach(prize => {
                const opt = document.createElement('option');
                opt.value = prize.text;
                opt.textContent = prize.text;
                select.appendChild(opt);
            });
        } catch (err) {
            select.disabled = false;
        }
    }
    // Pastikan input nama selalu enabled saat halaman load
    const nameInput = document.getElementById('name');
    if (nameInput) {
        nameInput.disabled = false;
        nameInput.readOnly = false;
        nameInput.style.pointerEvents = '';
    }
    // Panggil populatePrizeDropdown saat halaman load
    // populatePrizeDropdown(); // Dihilangkan agar tidak double, cukup updatePrizeDropdown dari vouchers-management.js
});
// === Custom Confirm Delete Popup Logic ===
let deleteVoucherCode = null;
let deleteVoucherName = null;
function showDeleteVoucherPopup(code, name) {
    deleteVoucherCode = code;
    deleteVoucherName = name;
    document.getElementById('confirm-delete-name').textContent = name || code;
    document.getElementById('confirm-delete-code').textContent = code;
    document.getElementById('confirm-delete-error').style.display = 'none';
    document.getElementById('confirm-delete-error').textContent = '';
    document.getElementById('voucher-confirm-delete-popup').classList.remove('hidden');
}
function hideDeleteVoucherPopup() {
    document.getElementById('voucher-confirm-delete-popup').classList.add('hidden');
    deleteVoucherCode = null;
    deleteVoucherName = null;
}
document.addEventListener('DOMContentLoaded', function() {
    // Close popup
    document.getElementById('close-confirm-delete').onclick = hideDeleteVoucherPopup;
    document.getElementById('cancel-delete-btn').onclick = hideDeleteVoucherPopup;
    // Confirm delete
    document.getElementById('confirm-delete-btn').onclick = function() {
        if (!deleteVoucherCode) return;
        this.disabled = true;
        fetch('update-voucher.php', {
            method: 'POST',
            headers: { 'Content-Type': 'application/json' },
            body: JSON.stringify({ code: deleteVoucherCode, action: 'delete' })
        })
        .then(res => res.json())
        .then(data => {
            this.disabled = false;
            if(data.success) {
                // Animasi fade-out pada baris voucher yang dihapus
                const row = document.querySelector(`.delete-voucher-btn[data-id='${deleteVoucherCode}']`)?.closest('tr');
                if (row) {
                    row.style.transition = 'opacity 0.5s';
                    row.style.opacity = 0;
                    setTimeout(() => {
                        row.remove();
                        hideDeleteVoucherPopup();
                        if(typeof loadVoucherDbList === 'function') loadVoucherDbList();
                        if(typeof window.updateVoucherStats === 'function') window.updateVoucherStats();
                    }, 500);
                } else {
                    hideDeleteVoucherPopup();
                    if(typeof loadVoucherDbList === 'function') loadVoucherDbList();
                    if(typeof window.updateVoucherStats === 'function') window.updateVoucherStats();
                }
            } else {
                document.getElementById('confirm-delete-error').textContent = data.message || 'Gagal menghapus voucher.';
                document.getElementById('confirm-delete-error').style.display = 'block';
            }
        })
        .catch(err => {
            this.disabled = false;
            document.getElementById('confirm-delete-error').textContent = err.message || 'Gagal menghapus voucher.';
            document.getElementById('confirm-delete-error').style.display = 'block';
        });
    };
    // ESC to close
    document.addEventListener('keydown', function(e) {
        if (e.key === 'Escape' && !document.getElementById('voucher-confirm-delete-popup').classList.contains('hidden')) {
            hideDeleteVoucherPopup();
        }
    });
});
// === Custom Copy Code Popup ===
function showCopyCodePopup(code) {
    // Hapus popup lama jika ada
    const existing = document.querySelector('.custom-copy-popup');
    if (existing) existing.remove();
    // Buat popup baru
    const popup = document.createElement('div');
    popup.className = 'custom-copy-popup';
    popup.innerHTML = `
        <div class="custom-success-content">
            <div class="custom-success-icon"><i class="fas fa-check-circle"></i></div>
            <div class="custom-success-msg">Voucher berhasil dibuat!</div>
            <div class="voucher-code-copy">Kode: <span id="copy-voucher-code">${code}</span></div>
            <button class="custom-success-close" title="Tutup">&times;</button>
            <button class="copy-code-btn" id="copy-code-btn">Salin Kode</button>
        </div>
    `;
    document.body.appendChild(popup);
    // Close handler
    popup.querySelector('.custom-success-close').onclick = () => popup.remove();
    // Copy handler
    popup.querySelector('#copy-code-btn').onclick = function() {
        const codeText = document.getElementById('copy-voucher-code').textContent;
        navigator.clipboard.writeText(codeText).then(() => {
            this.textContent = 'Disalin!';
            setTimeout(() => { this.textContent = 'Salin Kode'; }, 1500);
        });
    };
    // Klik overlay close
    popup.onclick = e => { if (e.target === popup) popup.remove(); };
    // Auto close
    setTimeout(() => { if (popup.parentNode) popup.remove(); }, 6000);
}
// === Integrasi popup voucher-success bawaan HTML ===
function showVoucherSuccessPopup({name, prize, expiry, status, code}) {
    const popup = document.querySelector('.voucher-success-popup');
    if (!popup) return;
    popup.classList.remove('hidden');
    document.getElementById('success-winner-name').textContent = name || '-';
    document.getElementById('success-prize-text').textContent = prize || '-';
    document.getElementById('success-expiry-date').textContent = expiry || '-';
    document.getElementById('success-status-badge').textContent = status || '-';
    document.getElementById('success-status-badge').className = 'status-badge ' + (status || '');
    document.getElementById('success-voucher-code').textContent = code || '-';
    // Salin kode
    document.getElementById('copy-success-code').onclick = function() {
        navigator.clipboard.writeText(code || '').then(() => {
            this.textContent = 'Disalin!';
            setTimeout(() => { this.innerHTML = '<i class="fas fa-copy"></i> Salin Kode'; }, 1500);
        });
    };
    // Tutup popup
    document.getElementById('close-success-popup').onclick = closeVoucherSuccessPopup;
    document.querySelector('.close-voucher-success').onclick = closeVoucherSuccessPopup;
}
function closeVoucherSuccessPopup() {
    const popup = document.querySelector('.voucher-success-popup');
    if (popup) popup.classList.add('hidden');
}