<?php
// CORS Security - Protect from unauthorized access
require_once '../../config/cors-security.php';
CorsManager::setSecureHeaders();
CorsManager::handlePreflightRequest();

// Include production config
require_once '../../config/production.php';

header('Content-Type: application/json');
header('Access-Control-Allow-Methods: POST');
header('Access-Control-Allow-Headers: Content-Type');
require_once 'config/database.php';
if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    http_response_code(405);
    echo json_encode(['success' => false, 'message' => 'Method not allowed']);
    exit;
}
$input = json_decode(file_get_contents('php://input'), true);
if (!$input || !isset($input['voucher_code']) || !isset($input['voucher_type'])) {
    http_response_code(400);
    echo json_encode(['success' => false, 'message' => 'Invalid input data']);
    exit;
}
try {
    $pdo->beginTransaction();
    $voucherCode = $input['voucher_code'];
    $voucherType = $input['voucher_type'];
    $currentDate = date('Y-m-d');
    $currentTime = date('H:i:s');
    // Insert ke tabel voucher usage
    $stmt = $pdo->prepare("
        INSERT INTO lucky_wheel_voucher_usage (voucher_code, voucher_type, usage_date, usage_time)
        VALUES (?, ?, ?, ?)
    ");
    $stmt->execute([$voucherCode, $voucherType, $currentDate, $currentTime]);
    // Update statistik harian
    $updateDaily = $pdo->prepare("
        INSERT INTO lucky_wheel_daily_stats (stat_date, total_vouchers_used)
        VALUES (?, 1)
        ON DUPLICATE KEY UPDATE
            total_vouchers_used = total_vouchers_used + 1
    ");
    $updateDaily->execute([$currentDate]);
    $pdo->commit();
    echo json_encode([
        'success' => true,
        'message' => 'Voucher usage saved successfully',
        'data' => [
            'voucher_code' => $voucherCode,
            'voucher_type' => $voucherType,
            'date' => $currentDate,
            'time' => $currentTime
        ]
    ]);
} catch (PDOException $e) {
    $pdo->rollBack();
    http_response_code(500);
    echo json_encode([
        'success' => false,
        'message' => 'Database error: ' . $e->getMessage()
    ]);
}
?>
