<?php
// CONTOH: get-vouchers-secure.php
// Include CORS security di awal file
require_once '../config/cors-security.php';

// CORS headers otomatis diset, akses terlindungi

// Include database config
require_once '../config/database.php';

try {
    // Query database
    $stmt = $pdo->prepare("SELECT * FROM vouchers ORDER BY created_at DESC");
    $stmt->execute();
    $vouchers = $stmt->fetchAll();
    
    // Return hasil
    header('Content-Type: application/json');
    echo json_encode([
        'success' => true,
        'data' => $vouchers,
        'count' => count($vouchers)
    ]);
    
} catch (Exception $e) {
    http_response_code(500);
    echo json_encode([
        'success' => false,
        'error' => 'Database error',
        'message' => ENVIRONMENT === 'production' ? 'Internal server error' : $e->getMessage()
    ]);
}
?>
