<?php
// SETUP DATABASE OTOMATIS - Solusi Error Dashboard
ini_set('display_errors', 1);
error_reporting(E_ALL);

echo "<h1>🔧 Setup Database Lucky Wheel - Auto Installer</h1>";
echo "<p>Script ini akan membantu setup database untuk mengatasi error dashboard.</p>";

// Step 1: Check MySQL connection
echo "<h2>Step 1: Test MySQL Connection</h2>";

try {
    // Try with root user first (default XAMPP)
    $pdo_root = new PDO("mysql:host=localhost;charset=utf8mb4", 'root', '');
    $pdo_root->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
    echo "<div style='color: green;'>✅ MySQL connection SUCCESS!</div><br>";
    
    // Step 2: Create Database
    echo "<h2>Step 2: Create Database</h2>";
    
    try {
        $pdo_root->exec("CREATE DATABASE IF NOT EXISTS lucky_wheel_admin CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci");
        echo "<div style='color: green;'>✅ Database 'lucky_wheel_admin' created successfully!</div><br>";
    } catch (Exception $e) {
        echo "<div style='color: orange;'>⚠️ Database might already exist: " . $e->getMessage() . "</div><br>";
    }
    
    // Step 3: Create User (with default password for testing)
    echo "<h2>Step 3: Create Database User</h2>";
    
    $test_password = 'LuckyWheel2024!'; // Default testing password
    
    try {
        // Drop user if exists
        try {
            $pdo_root->exec("DROP USER IF EXISTS 'lucky_wheel_user'@'localhost'");
        } catch (Exception $e) {
            // Ignore if user doesn't exist
        }
        
        // Create new user
        $pdo_root->exec("CREATE USER 'lucky_wheel_user'@'localhost' IDENTIFIED BY '$test_password'");
        $pdo_root->exec("GRANT ALL PRIVILEGES ON lucky_wheel_admin.* TO 'lucky_wheel_user'@'localhost'");
        $pdo_root->exec("FLUSH PRIVILEGES");
        
        echo "<div style='color: green;'>✅ User 'lucky_wheel_user' created successfully!</div>";
        echo "<div style='color: blue;'>📝 Password set to: <strong>$test_password</strong></div><br>";
        
    } catch (Exception $e) {
        echo "<div style='color: red;'>❌ Error creating user: " . $e->getMessage() . "</div><br>";
    }
    
    // Step 4: Test new connection
    echo "<h2>Step 4: Test New User Connection</h2>";
    
    try {
        $pdo_new = new PDO("mysql:host=localhost;dbname=lucky_wheel_admin;charset=utf8mb4", 'lucky_wheel_user', $test_password);
        $pdo_new->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
        echo "<div style='color: green;'>✅ New user connection SUCCESS!</div><br>";
        
        // Step 5: Create Tables
        echo "<h2>Step 5: Create Required Tables</h2>";
        
        // Lucky Wheel Spins Table
        $createSpinsTable = "
        CREATE TABLE IF NOT EXISTS lucky_wheel_spins (
            id INT AUTO_INCREMENT PRIMARY KEY,
            prize_name VARCHAR(100) NOT NULL,
            prize_type ENUM('jackpot', 'cash', 'bonus', 'voucher', 'try_again') NOT NULL,
            spin_date DATE NOT NULL,
            spin_time TIME NOT NULL,
            created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP
        ) ENGINE=InnoDB;
        ";
        
        // Daily Stats Table
        $createDailyStatsTable = "
        CREATE TABLE IF NOT EXISTS lucky_wheel_daily_stats (
            id INT AUTO_INCREMENT PRIMARY KEY,
            stat_date DATE NOT NULL UNIQUE,
            total_spins INT DEFAULT 0,
            total_vouchers_used INT DEFAULT 0,
            total_prizes_claimed INT DEFAULT 0,
            jackpot_count INT DEFAULT 0,
            cash_prizes_count INT DEFAULT 0,
            bonus_count INT DEFAULT 0,
            voucher_prizes_count INT DEFAULT 0,
            try_again_count INT DEFAULT 0,
            updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
        ) ENGINE=InnoDB;
        ";
        
        // Voucher Usage Table
        $createVoucherUsageTable = "
        CREATE TABLE IF NOT EXISTS lucky_wheel_voucher_usage (
            id INT AUTO_INCREMENT PRIMARY KEY,
            voucher_code VARCHAR(50) NOT NULL,
            voucher_type ENUM('regular', 'premium', 'vip') NOT NULL,
            usage_date DATE NOT NULL,
            usage_time TIME NOT NULL,
            created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP
        ) ENGINE=InnoDB;
        ";
        
        // Execute table creation
        $pdo_new->exec($createSpinsTable);
        echo "<div style='color: green;'>✅ Table 'lucky_wheel_spins' created!</div>";
        
        $pdo_new->exec($createDailyStatsTable);
        echo "<div style='color: green;'>✅ Table 'lucky_wheel_daily_stats' created!</div>";
        
        $pdo_new->exec($createVoucherUsageTable);
        echo "<div style='color: green;'>✅ Table 'lucky_wheel_voucher_usage' created!</div><br>";
        
        // Step 6: Insert sample data
        echo "<h2>Step 6: Insert Sample Data</h2>";
        
        try {
            // Insert today's stats
            $pdo_new->exec("
                INSERT IGNORE INTO lucky_wheel_daily_stats 
                (stat_date, total_spins, total_vouchers_used, total_prizes_claimed, jackpot_count) 
                VALUES (CURDATE(), 15, 8, 12, 2)
            ");
            
            echo "<div style='color: green;'>✅ Sample data inserted!</div><br>";
        } catch (Exception $e) {
            echo "<div style='color: orange;'>⚠️ Sample data might already exist</div><br>";
        }
        
    } catch (Exception $e) {
        echo "<div style='color: red;'>❌ New user connection FAILED: " . $e->getMessage() . "</div><br>";
    }
    
} catch (PDOException $e) {
    echo "<div style='color: red;'>❌ MySQL connection FAILED: " . $e->getMessage() . "</div>";
    echo "<div>Please make sure XAMPP MySQL is running!</div><br>";
}

echo "<h2>🎯 NEXT STEPS</h2>";
echo "<div style='background: #f0f8ff; padding: 15px; border-left: 4px solid #007acc;'>";
echo "<h3>1. Update Database Config Files</h3>";
echo "<p>Update these files with the password: <strong>$test_password</strong></p>";
echo "<ul>";
echo "<li><code>admin-domain/config/database.php</code></li>";
echo "<li><code>user-domain/config/database.php</code></li>";
echo "</ul>";

echo "<h3>2. Files to Update</h3>";
echo "<p>Change this line in both files:</p>";
echo "<code style='background: #ffe6e6;'>\$password = 'Your_Strong_DB_Password_Here!';</code><br>";
echo "<p>To:</p>";
echo "<code style='background: #e6ffe6;'>\$password = '$test_password';</code>";

echo "<h3>3. Test Dashboard</h3>";
echo "<p>After updating the files, test the dashboard:</p>";
echo "<a href='../dashboard/' target='_blank' style='background: #007acc; color: white; padding: 10px; text-decoration: none; border-radius: 5px;'>🎯 Open Dashboard</a>";
echo "</div>";

echo "<div style='background: #fff3cd; padding: 15px; border-left: 4px solid #ffc107; margin-top: 20px;'>";
echo "<h3>⚠️ SECURITY REMINDER</h3>";
echo "<p><strong>For Production:</strong> Change password '$test_password' to something more secure!</p>";
echo "</div>";
?>
