<?php
// Production database configuration for lucky-spin.ceritabahagia.lol
define('ENVIRONMENT', 'production');

// Database configuration - UPDATE THESE VALUES
$host = 'localhost'; // atau IP database server hosting
$dbname = 'ceritaba_lucky_spin'; // nama database di hosting
$username = 'ceritaba_admin'; // username database di hosting  
$password = 'YOUR_HOSTING_DB_PASSWORD'; // password database di hosting

try {
    // Create PDO connection
    $pdo = new PDO("mysql:host=$host;dbname=$dbname;charset=utf8mb4", $username, $password);
    
    // Set error mode based on environment
    if (ENVIRONMENT === 'production') {
        $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_SILENT);
    } else {
        $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
    }
    
    // Set default fetch mode to associative array
    $pdo->setAttribute(PDO::ATTR_DEFAULT_FETCH_MODE, PDO::FETCH_ASSOC);
    
} catch (PDOException $e) {
    if (ENVIRONMENT === 'production') {
        // In production, log error but don't show details
        error_log("Database connection failed: " . $e->getMessage());
        die("Service temporarily unavailable. Please try again later.");
    } else {
        die("Database connection failed: " . $e->getMessage());
    }
}
?>
