<?php
// Production Configuration - Security Settings
// This file should be included at the top of every PHP file in production

// 1. DISABLE DEBUG MODE (Very Important!)
error_reporting(0);                    // Don't show any errors
ini_set('display_errors', 0);          // Don't display errors to user
ini_set('display_startup_errors', 0);  // Don't display startup errors
ini_set('log_errors', 1);              // Still log errors to file
ini_set('error_log', __DIR__ . '/../logs/error.log'); // Log to file

// 2. SECURITY HEADERS
header('X-Content-Type-Options: nosniff');
header('X-Frame-Options: DENY');
header('X-XSS-Protection: 1; mode=block');
header('Referrer-Policy: strict-origin-when-cross-origin');
header('Content-Security-Policy: default-src \'self\'');

// 3. HIDE SERVER INFO
header_remove('X-Powered-By');
ini_set('expose_php', 0);

// 4. SESSION SECURITY
ini_set('session.cookie_httponly', 1);
ini_set('session.cookie_secure', 1);
ini_set('session.use_only_cookies', 1);
ini_set('session.cookie_samesite', 'Strict');

// 5. PREVENT DIRECT ACCESS TO CONFIG FILES
if (basename($_SERVER['PHP_SELF']) == 'production.php') {
    http_response_code(403);
    die('Access denied');
}

// 6. CONSTANTS
define('ENVIRONMENT', 'production');
define('DEBUG_MODE', false);
define('LOG_ERRORS', true);
?>
