// Dashboard Admin Initialization and Functionality
// Initialize AOS
AOS.init({
    duration: 800,
    easing: 'ease-in-out',
    once: true,
    offset: 100
});
// Fallback logout handler
function handleLogout(event) {
    event.preventDefault();
    event.stopPropagation();
    // Check if showCustomConfirm is available
    if (typeof showCustomConfirm === 'function') {
        showCustomConfirm('Apakah Anda yakin ingin keluar?', 'Konfirmasi Logout')
            .then(confirmed => {
                if (confirmed) {
                    localStorage.removeItem('adminLoggedIn');
                    if (typeof showCustomAlert === 'function') {
                        showCustomAlert('Logout berhasil!', 'success', 'Berhasil');
                    }
                    setTimeout(() => {
                        window.location.href = 'index.html';
                    }, 1500);
                }
            })
            .catch(error => {
                if (confirm('Apakah Anda yakin ingin keluar?')) {
                    window.location.href = 'index.html';
                }
            });
    } else {
        if (confirm('Apakah Anda yakin ingin keluar?')) {
            localStorage.removeItem('adminLoggedIn');
            window.location.href = 'index.html';
        }
    }
}
    // Logout button (biarkan logic yang sudah ada)
    setTimeout(() => {
        const logoutBtn = document.getElementById('logout-btn');
        if (logoutBtn) {
            const newLogoutBtn = logoutBtn.cloneNode(true);
            logoutBtn.parentNode.replaceChild(newLogoutBtn, logoutBtn);
            document.getElementById('logout-btn').onclick = async function(e) {
                e.preventDefault();
                e.stopPropagation();
                try {
                    const confirmed = await showCustomConfirm('Apakah Anda yakin ingin keluar?', 'Konfirmasi Logout');
                    if (confirmed) {
                        localStorage.removeItem('adminLoggedIn');
                        showCustomAlert('Logout berhasil. Redirect...', 'success', 'Berhasil');
                        setTimeout(() => {
                            window.location.href = 'index.html';
                        }, 1500);
                    }
                } catch (error) {
                    alert('Error: ' + error.message);
                }
            };
        }
    }, 2000);