// Dashboard Functionality
// Inisialisasi statistik Lucky Wheel modern
document.addEventListener('DOMContentLoaded', function() {
    // Set current date
    const currentDate = new Date();
    const options = { day: 'numeric', month: 'long', year: 'numeric' };
    const formattedDate = currentDate.toLocaleDateString('id-ID', options);
    document.querySelector('.date-display').textContent = formattedDate;
    // Hanya gunakan statistik Lucky Wheel modern
    initializeLuckyWheelStats();
    // Event listeners untuk chart period (jika ada)
    document.querySelectorAll('.chart-btn').forEach(button => {
        button.addEventListener('click', function() {
            const period = this.getAttribute('data-period');
            const chartBtns = this.parentElement.querySelectorAll('.chart-btn');
            chartBtns.forEach(btn => btn.classList.remove('active'));
            this.classList.add('active');
            // updateVoucherChartByPeriod(period); // Optional: jika chart period masih dipakai
        });
    });
    // Refresh manual
    const refreshIcon = document.getElementById('refresh-icon');
    if (refreshIcon) {
        refreshIcon.addEventListener('click', manualRefreshStats);
        refreshIcon.style.cursor = 'pointer';
        refreshIcon.title = 'Click to refresh manually';
    }
    // // Logout button (biarkan logic yang sudah ada)
    // setTimeout(() => {
    //     const logoutBtn = document.getElementById('logout-btn');
    //     if (logoutBtn) {
    //         const newLogoutBtn = logoutBtn.cloneNode(true);
    //         logoutBtn.parentNode.replaceChild(newLogoutBtn, logoutBtn);
    //         document.getElementById('logout-btn').onclick = async function(e) {
    //             e.preventDefault();
    //             e.stopPropagation();
    //             try {
    //                 const confirmed = await showCustomConfirm('Apakah Anda yakin ingin keluar?', 'Konfirmasi Logout');
    //                 if (confirmed) {
    //                     localStorage.removeItem('adminLoggedIn');
    //                     showCustomAlert('Logout berhasil. Redirect...', 'success', 'Berhasil');
    //                     setTimeout(() => {
    //                         window.location.href = 'index.html';
    //                     }, 1500);
    //                 }
    //             } catch (error) {
    //                 alert('Error: ' + error.message);
    //             }
    //         };
    //     }
    // }, 2000);
    // Animasi, shortcut, dsb (biarkan jika masih dipakai)
    if (typeof addScrollAnimations === 'function') addScrollAnimations();
    if (typeof addKeyboardShortcuts === 'function') addKeyboardShortcuts();
    if (typeof animateCardsOnLoad === 'function') animateCardsOnLoad();
    if (typeof animateNotificationBell === 'function') animateNotificationBell();
});
// =============== LUCKY WHEEL STATISTICS ===============
let luckyWheelChart = null;
let prizeDistributionChart = null;
let refreshInterval = null;
let countdownInterval = null;
let refreshCountdown = 30;
// Initialize Lucky Wheel Statistics
function initializeLuckyWheelStats() {
    // Load initial data
    loadLuckyWheelStats();
    // Setup auto-refresh
    setupAutoRefresh();
    // Setup charts
    initializeLuckyWheelCharts();
}
// Load Lucky Wheel Statistics from API
async function loadLuckyWheelStats() {
    try {
        showLoadingStates();
        const response = await fetch('../get-lucky-wheel-stats.php');
        const result = await response.json();
        if (result.success && result.data && Array.isArray(result.data.last7Days)) {
            updateStatisticCards(result.data);
            updateCharts(result.data);
            } else {
            showErrorStates();
        }
    } catch (error) {
        showErrorStates();
    }
}
// Show loading states for stat cards
function showLoadingStates() {
    const statNumbers = document.querySelectorAll('.stat-number');
    statNumbers.forEach(el => {
        el.classList.add('loading');
    });
}
// Show error states
function showErrorStates() {
    const statNumbers = document.querySelectorAll('.stat-number');
    statNumbers.forEach(el => {
        el.classList.remove('loading');
        el.textContent = 'Error';
    });
}
// Update statistic cards with real data
function updateStatisticCards(data) {
    const { totalStats, todayStats } = data;
    // Update with animation
    updateStatCard('total-vouchers-used-stat', totalStats.total_vouchers_used || 0);
    updateStatCard('today-vouchers', todayStats.total_vouchers_used || 0);
    updateStatCard('total-spins-stat', totalStats.total_spins || 0);
    updateStatCard('today-spins', todayStats.total_spins || 0);
    updateStatCard('total-prizes-stat', totalStats.total_prizes_claimed || 0);
    updateStatCard('today-prizes', todayStats.total_prizes_claimed || 0);
    const totalJackpots = (totalStats.jackpot_count || 0) + (totalStats.bonus_count || 0);
    const todayJackpots = (todayStats.jackpot_count || 0) + (todayStats.bonus_count || 0);
    updateStatCard('total-jackpots-stat', totalJackpots);
    updateStatCard('today-jackpots', todayJackpots);
    // Update mini stats
    if (data.last7Days && data.last7Days.length > 0) {
        const avgSpins = Math.round(data.last7Days.reduce((sum, day) => sum + (day.total_spins || 0), 0) / data.last7Days.length);
        const avgVouchers = Math.round(data.last7Days.reduce((sum, day) => sum + (day.total_vouchers_used || 0), 0) / data.last7Days.length);
        updateElement('avg-spins-day', avgSpins);
        updateElement('avg-vouchers-day', avgVouchers);
    }
    // Calculate win rate
    const winRate = totalStats.total_spins > 0 ? 
        Math.round(((totalStats.total_prizes_claimed || 0) / totalStats.total_spins) * 100) : 0;
    updateElement('win-rate', winRate + '%');
}
// Update individual stat card with animation
function updateStatCard(elementId, newValue) {
    const element = document.getElementById(elementId);
    if (element) {
        element.classList.remove('loading');
        const currentValue = parseInt(element.textContent) || 0;
        if (currentValue !== newValue) {
            element.classList.add('updated');
            element.textContent = newValue.toLocaleString();
            setTimeout(() => {
                element.classList.remove('updated');
            }, 500);
        } else {
            element.textContent = newValue.toLocaleString();
        }
    }
}
// Update element content
function updateElement(elementId, newValue) {
    const element = document.getElementById(elementId);
    if (element) {
        element.textContent = newValue;
    }
}
// Initialize Charts
function initializeLuckyWheelCharts() {
    // Destroy previous chart instance if exists
    if (window.luckyWheelChart && typeof window.luckyWheelChart.destroy === 'function') {
        window.luckyWheelChart.destroy();
    }
    if (window.prizeDistributionChart && typeof window.prizeDistributionChart.destroy === 'function') {
        window.prizeDistributionChart.destroy();
    }
    // Activity Chart
    const activityCtx = document.getElementById('lucky-wheel-activity-chart');
    if (activityCtx) {
        try {
            window.luckyWheelChart = new Chart(activityCtx, {
                type: 'line',
                data: {
                    labels: [],
                    datasets: [
                        {
                            label: 'Spin',
                            data: [],
                            borderColor: '#FF6600',
                            backgroundColor: 'rgba(255, 102, 0, 0.1)',
                            tension: 0.4,
                            fill: true
                        },
                        {
                            label: 'Voucher Digunakan',
                            data: [],
                            borderColor: '#4CAF50',
                            backgroundColor: 'rgba(76, 175, 80, 0.1)',
                            tension: 0.4,
                            fill: true
                        }
                    ]
                },
                options: {
                    responsive: true,
                    maintainAspectRatio: false,
                    plugins: {
                        legend: {
                            labels: { color: '#fff' }
                        }
                    },
                    scales: {
                        x: { 
                            ticks: { color: '#fff' },
                            grid: { color: 'rgba(255, 255, 255, 0.1)' }
                        },
                        y: { 
                            ticks: { color: '#fff' },
                            grid: { color: 'rgba(255, 255, 255, 0.1)' }
                        }
                    }
                }
            });
        } catch (e) {
            }
    } else {
        }
    // Prize Distribution Chart
    const prizeCtx = document.getElementById('lucky-wheel-prizes-chart');
    if (prizeCtx) {
        try {
            window.prizeDistributionChart = new Chart(prizeCtx, {
                type: 'doughnut',
                data: {
                    labels: [],
                    datasets: [{
                        data: [],
                        backgroundColor: [
                            '#FF5722', '#FF9800', '#FFB74D', '#FFCC80',
                            '#FF7043', '#BF360C', '#E64A19', '#FFA726'
                        ],
                        borderWidth: 2,
                        borderColor: '#1a1a1a'
                    }]
                },
                options: {
                    responsive: true,
                    maintainAspectRatio: false,
                    plugins: {
                        legend: {
                            labels: { color: '#fff' }
                        }
                    }
                }
            });
        } catch (e) {
            }
    } else {
        }
}
// Update Charts with new data
function updateCharts(data) {
    // Debug log untuk memastikan fungsi dijalankan dan data diterima
    if (window.luckyWheelChart && Array.isArray(data.last7Days)) {
        const sortedDays = data.last7Days.sort((a, b) => new Date(a.stat_date) - new Date(b.stat_date));
        window.luckyWheelChart.data.labels = sortedDays.map(day => {
            const date = new Date(day.stat_date);
            return date.toLocaleDateString('id-ID', { day: '2-digit', month: 'short' });
        });
        window.luckyWheelChart.data.datasets[0].data = sortedDays.map(day => day.total_spins || 0);
        window.luckyWheelChart.data.datasets[1].data = sortedDays.map(day => day.total_vouchers_used || 0);
        window.luckyWheelChart.update();
    } else {
        }
    // Update Prize Distribution Chart
    if (prizeDistributionChart && data.prizeDistribution) {
        const prizes = Object.entries(data.prizeDistribution);
        prizeDistributionChart.data.labels = prizes.map(([name]) => name);
        prizeDistributionChart.data.datasets[0].data = prizes.map(([, count]) => count);
        prizeDistributionChart.update();
        // Update legend
        updatePrizeLegend(prizes);
    }
}
// Update Prize Legend
function updatePrizeLegend(prizes) {
    const legendContainer = document.getElementById('prize-legend');
    if (!legendContainer) return;
    const total = prizes.reduce((sum, [, count]) => sum + count, 0);
    legendContainer.innerHTML = prizes.map(([name, count], index) => {
        const percentage = total > 0 ? Math.round((count / total) * 100) : 0;
        const colors = ['#FF5722', '#FF9800', '#FFB74D', '#FFCC80', '#FF7043', '#BF360C', '#E64A19', '#FFA726'];
        return `
            <div class="legend-item">
                <span class="legend-color" style="background-color: ${colors[index] || '#ccc'}"></span>
                <span class="legend-text">${name}</span>
                <span class="legend-percent">${percentage}%</span>
            </div>
        `;
    }).join('');
}
// Setup Auto Refresh
function setupAutoRefresh() {
    // Clear existing intervals
    if (refreshInterval) clearInterval(refreshInterval);
    if (countdownInterval) clearInterval(countdownInterval);
    // Setup refresh interval (30 seconds)
    refreshInterval = setInterval(() => {
        loadLuckyWheelStats();
        refreshCountdown = 30;
        // Add refresh animation
        const refreshIcon = document.getElementById('refresh-icon');
        if (refreshIcon) {
            refreshIcon.classList.add('refreshing');
            setTimeout(() => {
                refreshIcon.classList.remove('refreshing');
            }, 1000);
        }
    }, 30000);
    // Setup countdown
    countdownInterval = setInterval(() => {
        refreshCountdown--;
        const countdownElement = document.getElementById('refresh-countdown');
        if (countdownElement) {
            countdownElement.textContent = refreshCountdown;
        }
        if (refreshCountdown <= 0) {
            refreshCountdown = 30;
        }
    }, 1000);
}
// Manual refresh function
function manualRefreshStats() {
    loadLuckyWheelStats();
    refreshCountdown = 30;
    const refreshIcon = document.getElementById('refresh-icon');
    if (refreshIcon) {
        refreshIcon.classList.add('refreshing');
        setTimeout(() => {
            refreshIcon.classList.remove('refreshing');
        }, 1000);
    }
}
// Initialize when DOM is loaded
document.addEventListener('DOMContentLoaded', function() {
    // Initialize Lucky Wheel Stats after other dashboard elements
    setTimeout(() => {
        initializeLuckyWheelStats();
    }, 1000);
    // Add click handler for manual refresh
    const refreshIcon = document.getElementById('refresh-icon');
    if (refreshIcon) {
        refreshIcon.addEventListener('click', manualRefreshStats);
        refreshIcon.style.cursor = 'pointer';
        refreshIcon.title = 'Click to refresh manually';
    }
});
// Cleanup on page unload
window.addEventListener('beforeunload', function() {
    if (refreshInterval) clearInterval(refreshInterval);
    if (countdownInterval) clearInterval(countdownInterval);
});