<?php
header('Content-Type: application/json');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET');
header('Access-Control-Allow-Headers: Content-Type');
require_once 'config/database.php';
if ($_SERVER['REQUEST_METHOD'] !== 'GET') {
    http_response_code(405);
    echo json_encode(['success' => false, 'message' => 'Method not allowed']);
    exit;
}
try {
    // Ambil statistik total
    $totalStats = $pdo->query("
        SELECT
            COALESCE(SUM(total_spins), 0) as total_spins,
            COALESCE(SUM(total_vouchers_used), 0) as total_vouchers_used,
            COALESCE(SUM(total_prizes_claimed), 0) as total_prizes_claimed,
            COALESCE(SUM(jackpot_count), 0) as jackpot_count,
            COALESCE(SUM(cash_prizes_count), 0) as cash_prizes_count,
            COALESCE(SUM(bonus_count), 0) as bonus_count,
            COALESCE(SUM(voucher_prizes_count), 0) as voucher_prizes_count,
            COALESCE(SUM(try_again_count), 0) as try_again_count
        FROM lucky_wheel_daily_stats
    ")->fetch(PDO::FETCH_ASSOC);
    // Ambil distribusi hadiah detail
    $prizeDistribution = $pdo->query("
        SELECT
            prize_name,
            COUNT(*) as count
        FROM lucky_wheel_spins
        GROUP BY prize_name
        ORDER BY count DESC
    ")->fetchAll(PDO::FETCH_ASSOC);
    // Format distribusi untuk frontend
    $distributionFormatted = [];
    foreach ($prizeDistribution as $prize) {
        $distributionFormatted[$prize['prize_name']] = (int)$prize['count'];
    }
    // Ambil statistik 7 hari terakhir
    $last7Days = $pdo->query("
        SELECT
            stat_date,
            total_spins,
            total_vouchers_used,
            total_prizes_claimed
        FROM lucky_wheel_daily_stats
        WHERE stat_date >= DATE_SUB(CURDATE(), INTERVAL 7 DAY)
        ORDER BY stat_date DESC
    ");
    $last7DaysData = $last7Days ? $last7Days->fetchAll(PDO::FETCH_ASSOC) : [];
    if (!$last7DaysData || count($last7DaysData) === 0) {
        error_log('API get-lucky-wheel-stats.php: last7Days kosong atau tidak ditemukan.');
    }
    // Ambil statistik hari ini
    $todayStats = $pdo->query("
        SELECT
            total_spins,
            total_vouchers_used,
            total_prizes_claimed,
            jackpot_count,
            cash_prizes_count,
            bonus_count,
            voucher_prizes_count,
            try_again_count
        FROM lucky_wheel_daily_stats
        WHERE stat_date = CURDATE()
    ")->fetch(PDO::FETCH_ASSOC);
    if (!$todayStats) {
        $todayStats = [
            'total_spins' => 0,
            'total_vouchers_used' => 0,
            'total_prizes_claimed' => 0,
            'jackpot_count' => 0,
            'cash_prizes_count' => 0,
            'bonus_count' => 0,
            'voucher_prizes_count' => 0,
            'try_again_count' => 0
        ];
    }
    echo json_encode([
        'success' => true,
        'data' => [
            'totalStats' => $totalStats,
            'prizeDistribution' => $distributionFormatted,
            'last7Days' => $last7DaysData,
            'todayStats' => $todayStats,
            'lastUpdate' => date('Y-m-d H:i:s')
        ]
    ]);
} catch (PDOException $e) {
    http_response_code(500);
    echo json_encode([
        'success' => false,
        'message' => 'Database error: ' . $e->getMessage()
    ]);
}
?>
