<?php
require_once __DIR__ . '/../config/database.php';
try {
    $sql = 'ALTER TABLE vouchers ADD COLUMN prize_name VARCHAR(255) DEFAULT NULL AFTER value';
    $result = $pdo->exec($sql);
    echo "Column prize_name added successfully to vouchers table\n";
    // Also check table structure
    $stmt = $pdo->query('DESCRIBE vouchers');
    $columns = $stmt->fetchAll(PDO::FETCH_ASSOC);
    echo "Current table structure:\n";
    foreach ($columns as $column) {
        echo '- ' . $column['Field'] . ' (' . $column['Type'] . ")\n";
    }
} catch (Exception $e) {
    if (strpos($e->getMessage(), 'Duplicate column') !== false) {
        echo "Column prize_name already exists\n";
        // Show current structure
        $stmt = $pdo->query('DESCRIBE vouchers');
        $columns = $stmt->fetchAll(PDO::FETCH_ASSOC);
        echo "Current table structure:\n";
        foreach ($columns as $column) {
            echo '- ' . $column['Field'] . ' (' . $column['Type'] . ")\n";
        }
    } else {
        echo 'Error: ' . $e->getMessage() . "\n";
    }
}
?>
