<?php
header('Content-Type: application/json');
require_once __DIR__ . '/../config/database.php';
// Enable CORS
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET, POST');
header('Access-Control-Allow-Headers: Content-Type');
session_start();
try {
    $onlyActive = isset($_GET['active']) && $_GET['active'] === 'true';
    // Build query
    $sql = "SELECT * FROM lucky_wheel_prizes";
    if ($onlyActive) {
        $sql .= " WHERE status = 'active'";
    }
    $sql .= " ORDER BY position ASC";
    $stmt = $pdo->query($sql);
    $prizes = $stmt->fetchAll(PDO::FETCH_ASSOC);
    // Calculate statistics
    $stats = [
        'total' => count($prizes),
        'active' => 0,
        'inactive' => 0,
        'total_probability' => 0
    ];
    foreach ($prizes as $prize) {
        if ($prize['status'] === 'active') {
            $stats['active']++;
            $stats['total_probability'] += floatval($prize['probability']);
        } else {
            $stats['inactive']++;
        }
    }
    $result = [
        'success' => true,
        'prizes' => $prizes,
        'stats' => $stats,
        'message' => 'Data berhasil dimuat'
    ];
    echo json_encode($result);
} catch (Exception $e) {
    error_log("get-prizes.php error: " . $e->getMessage());
    echo json_encode([
        'success' => false,
        'message' => 'Gagal memuat data: ' . $e->getMessage(),
        'prizes' => [],
        'stats' => [
            'total' => 0,
            'active' => 0,
            'inactive' => 0,
            'total_probability' => 0
        ]
    ]);
}
?>
