<?php
header('Content-Type: application/json');
require_once __DIR__ . '/../config/database.php';
// Enable CORS for wheel access
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET');
header('Access-Control-Allow-Headers: Content-Type');
try {
    // Get only active prizes ordered by position
    $sql = "SELECT name as text, color, probability FROM lucky_wheel_prizes WHERE status = 'active' ORDER BY position ASC";
    $stmt = $pdo->query($sql);
    $prizes = $stmt->fetchAll(PDO::FETCH_ASSOC);
    // Convert probability from percentage to decimal for wheel.js
    foreach ($prizes as &$prize) {
        $prize['probability'] = floatval($prize['probability']) / 100;
    }
    // Verify we have exactly 8 prizes
    if (count($prizes) !== 8) {
        throw new Exception("Expected 8 active prizes, found " . count($prizes));
    }
    // Calculate segments count
    $segments = count($prizes);
    // Calculate total probability (should be 1.0 or close)
    $totalProb = array_sum(array_column($prizes, 'probability'));
    echo json_encode([
        'success' => true,
        'segments' => $segments,
        'prizes' => $prizes,
        'total_probability' => $totalProb,
        'message' => 'Wheel prizes loaded successfully',
        'timestamp' => date('Y-m-d H:i:s')
    ]);
} catch (Exception $e) {
    // Return fallback data if database fails
    $fallbackPrizes = [
        ['text' => 'JACKPOT 1JT', 'color' => '#FF5722', 'probability' => 0.01],
        ['text' => 'Rp 100,000', 'color' => '#FF9800', 'probability' => 0.10],
        ['text' => 'BONUS 500K', 'color' => '#FFB74D', 'probability' => 0.05],
        ['text' => 'Voucher 50K', 'color' => '#FFCC80', 'probability' => 0.15],
        ['text' => 'Rp 200,000', 'color' => '#FF7043', 'probability' => 0.08],
        ['text' => 'Coba Lagi', 'color' => '#BF360C', 'probability' => 0.30],
        ['text' => 'BONUS 888K', 'color' => '#E64A19', 'probability' => 0.03],
        ['text' => 'Rp 300,000', 'color' => '#FFA726', 'probability' => 0.08]
    ];
    echo json_encode([
        'success' => false,
        'segments' => 8,
        'prizes' => $fallbackPrizes,
        'total_probability' => 0.80,
        'message' => 'Using fallback data: ' . $e->getMessage(),
        'error' => true,
        'timestamp' => date('Y-m-d H:i:s')
    ]);
}
?>
