<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Kelola Hadiah - Lucky Wheel Admin</title>
    <link rel="stylesheet" href="../css/admin.css">
    <link rel="stylesheet" href="../dashboard/css/dashboard.css">
    <link rel="stylesheet" href="../dashboard/css/dashboard-layout.css">
    <link rel="stylesheet" href="../dashboard/css/dashboard-widgets.css">
    <link rel="stylesheet" href="css/prizes.css">
    <!-- Font Awesome -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
    <!-- AOS Animation -->
    <link href="https://unpkg.com/aos@2.3.1/dist/aos.css" rel="stylesheet">
</head>
<body>
    <div class="admin-container">
        <!-- Progress Loading Bar -->
        <div class="loading-bar">
            <div class="loading-progress"></div>
        </div>
        
        <header class="admin-header">
            <div class="header-left">
                <div class="logo">
                    <img src="../../assets/img/logo-lembagatoto.webp" alt="Lucky Wheel Logo">
                </div>
                <div class="header-info">
                    <h1>Kelola Hadiah</h1>
                    <p class="header-subtitle">Atur hadiah yang ada di Lucky Wheel</p>
                </div>
            </div>
            <div class="header-actions">
                <div class="weather-widget">
                    <i class="fas fa-sun"></i>
                    <span>28°C</span>
                </div>
                <span class="date-display" id="live-date">25 Juni 2025</span>
                <button class="header-btn refresh-btn" title="Refresh Data"><i class="fas fa-sync-alt"></i></button>
                <button class="header-btn notifications-btn" title="Notifikasi"><i class="fas fa-bell"></i><span class="notification-badge">3</span></button>
                <div class="user-profile">
                    <img src="../../assets/img/favicon.ico" alt="Admin" class="profile-avatar">
                    <span class="profile-name">Admin</span>
                </div>
            </div>
        </header>

        <div class="dashboard-container">
            <div class="admin-sidebar">
                <nav class="admin-nav">
                    <ul>
                        <li><a href="../dashboard/index.html"><i class="fas fa-tachometer-alt"></i> <span>Dashboard</span></a></li>
                        <li><a href="../vouchers/index.html"><i class="fas fa-ticket-alt"></i> <span>Voucher</span></a></li>
                        <li class="active"><a href="index.html"><i class="fas fa-gift"></i> <span>Hadiah</span></a></li>
                        <li><a href="../pengguna/index.html"><i class="fas fa-users"></i> <span>Pemenang</span></a></li>
                        <li><a href="#"><i class="fas fa-chart-bar"></i> <span>Statistik</span></a></li>
                        <li><a href="#"><i class="fas fa-cog"></i> <span>Pengaturan</span></a></li>
                    </ul>
                </nav>
                <div class="admin-user">
                    <div class="user-avatar">
                        <i class="fas fa-user-circle"></i>
                    </div>
                    <div class="user-info">
                        <p class="user-name">Admin</p>
                        <button id="logout-btn" class="small-btn"><i class="fas fa-sign-out-alt"></i> Logout</button>
                    </div>
                </div>
            </div>

            <div class="dashboard-content">
                <!-- Page Header -->
                <div class="page-header enhanced-header" data-aos="fade-down">
                    <div class="header-background-pattern"></div>
                    <div class="page-title">
                        <div class="title-icon-wrapper">
                            <i class="fas fa-gift animated-icon"></i>
                        </div>
                        <div class="title-content">
                            <h2>Kelola Hadiah Lucky Wheel</h2>
                            <p>Atur dan kelola hadiah yang tersedia di roda putar</p>
                            <div class="title-accent"></div>
                        </div>
                    </div>
                    <div class="page-actions">
                        <button class="action-btn success enhanced-btn" id="add-prize-btn">
                            <div class="btn-background"></div>
                            <i class="fas fa-plus"></i>
                            <span>Tambah Hadiah</span>
                            <div class="btn-shine"></div>
                        </button>
                        <button class="action-btn secondary enhanced-btn" id="preview-wheel-btn">
                            <div class="btn-background"></div>
                            <i class="fas fa-eye"></i>
                            <span>Preview Roda</span>
                            <div class="btn-shine"></div>
                        </button>
                    </div>
                </div>

                <!-- Prizes Management -->
                <div class="content-grid">
                    <div class="prizes-list-section" data-aos="fade-right">
                        <div class="section-card glass-card">
                            <div class="card-header enhanced-card-header">
                                <div class="header-icon-wrapper">
                                    <i class="fas fa-list pulse-icon"></i>
                                </div>
                                <div class="header-content">
                                    <h3>Daftar Hadiah</h3>
                                    <p class="header-subtitle">Kelola semua hadiah</p>
                                </div>
                                <button class="enhanced-small-btn" id="refresh-prizes-btn">
                                    <i class="fas fa-sync-alt"></i> Refresh
                                </button>
                            </div>
                            <div class="card-body">
                                <div class="prizes-table-container">
                                    <table class="prizes-table" id="prizes-table">
                                        <thead>
                                            <tr>
                                                <th>Posisi</th>
                                                <th>Hadiah</th>
                                                <th>Tipe</th>
                                                <th>Nilai</th>
                                                <th>Probabilitas</th>
                                                <th>Status</th>
                                                <th>Aksi</th>
                                            </tr>
                                        </thead>
                                        <tbody id="prizes-table-body">
                                            <tr class="loading-row">
                                                <td colspan="7">
                                                    <div class="loading-spinner">
                                                        <i class="fas fa-spinner fa-spin"></i>
                                                        <span>Memuat data hadiah...</span>
                                                    </div>
                                                </td>
                                            </tr>
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Prize Form -->
                    <div class="prize-form-section" data-aos="fade-left">
                        <div class="section-card glass-card">
                            <div class="card-header enhanced-card-header">
                                <div class="header-icon-wrapper">
                                    <i class="fas fa-plus-circle bounce-icon"></i>
                                </div>
                                <div class="header-content">
                                    <h3><span id="form-title">Tambah Hadiah Baru</span></h3>
                                    <p class="header-subtitle">Isi form untuk menambah hadiah</p>
                                </div>
                            </div>
                            <div class="card-body enhanced-card-body">
                                <form id="prize-form" class="enhanced-form">
                                    <input type="hidden" id="prize-id">
                                    
                                    <div class="form-group enhanced-form-group">
                                        <label for="prize-name" class="enhanced-label">
                                            <div class="label-icon">
                                                <i class="fas fa-tag"></i>
                                            </div>
                                            <span>Nama Hadiah</span>
                                        </label>
                                        <input type="text" id="prize-name" class="form-control enhanced-input" placeholder="Contoh: 10.000 Rupiah" required>
                                    </div>

                                    <div class="form-group enhanced-form-group">
                                        <label for="prize-type" class="enhanced-label">
                                            <div class="label-icon">
                                                <i class="fas fa-layer-group"></i>
                                            </div>
                                            <span>Tipe Hadiah</span>
                                        </label>
                                        <select id="prize-type" class="form-control enhanced-input" required>
                                            <option value="">Pilih Tipe</option>
                                            <option value="money">💰 Uang</option>
                                            <option value="voucher">🎫 Voucher</option>
                                            <option value="freespin">🔄 Free Spin</option>
                                            <option value="bonus">⚡ Bonus Credit</option>
                                            <option value="other">🎁 Lainnya</option>
                                        </select>
                                    </div>

                                    <div class="form-group">
                                        <label for="prize-value">
                                            <i class="fas fa-dollar-sign"></i> Nilai
                                        </label>
                                        <input type="text" id="prize-value" class="form-control" placeholder="Contoh: 10000 atau 20%" required>
                                        <small class="form-hint">Untuk uang: nominal rupiah, untuk voucher: persentase</small>
                                    </div>

                                    <div class="form-row">
                                        <div class="form-group">
                                            <label for="prize-icon">
                                                <i class="fas fa-icons"></i> Icon
                                            </label>
                                            <select id="prize-icon" class="form-control">
                                                <option value="fas fa-coins">Koin</option>
                                                <option value="fas fa-gift">Hadiah</option>
                                                <option value="fas fa-ticket-alt">Tiket</option>
                                                <option value="fas fa-star">Bintang</option>
                                                <option value="fas fa-redo-alt">Refresh</option>
                                                <option value="fas fa-trophy">Trophy</option>
                                                <option value="fas fa-times">Silang</option>
                                            </select>
                                        </div>

                                        <div class="form-group">
                                            <label for="prize-color">
                                                <i class="fas fa-palette"></i> Warna
                                            </label>
                                            <input type="color" id="prize-color" class="form-control color-input" value="#FF6600">
                                        </div>
                                    </div>

                                    <div class="form-row">
                                        <div class="form-group">
                                            <label for="prize-probability">
                                                <i class="fas fa-percentage"></i> Probabilitas (%)
                                            </label>
                                            <input type="number" id="prize-probability" class="form-control" min="0" max="100" step="0.01" value="10.00">
                                        </div>

                                        <div class="form-group">
                                            <label for="prize-position">
                                                <i class="fas fa-sort-numeric-up"></i> Posisi
                                            </label>
                                            <input type="number" id="prize-position" class="form-control" min="1" value="1">
                                        </div>
                                    </div>

                                    <div class="form-group">
                                        <label for="prize-status">
                                            <i class="fas fa-toggle-on"></i> Status
                                        </label>
                                        <select id="prize-status" class="form-control" required>
                                            <option value="active">Aktif</option>
                                            <option value="inactive">Nonaktif</option>
                                        </select>
                                    </div>

                                    <div class="form-actions">
                                        <button type="button" class="btn-secondary" id="cancel-btn">
                                            <i class="fas fa-times"></i> Batal
                                        </button>
                                        <button type="submit" class="btn-primary">
                                            <i class="fas fa-save"></i> <span id="submit-text">Simpan Hadiah</span>
                                        </button>
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Quick Actions -->
                <div class="quick-actions-section enhanced-quick-actions" data-aos="fade-up">
                    <div class="section-card glass-card">
                        <div class="card-header enhanced-card-header">
                            <div class="header-icon-wrapper">
                                <i class="fas fa-bolt lightning-icon"></i>
                            </div>
                            <div class="header-content">
                                <h3>Aksi Cepat</h3>
                                <p class="header-subtitle">Tools untuk manajemen hadiah</p>
                            </div>
                        </div>
                        <div class="card-body">
                            <div class="quick-actions-grid enhanced-grid">
                                <button class="quick-action-btn enhanced-quick-btn" id="reset-probability-btn">
                                    <div class="btn-icon-wrapper">
                                        <i class="fas fa-balance-scale"></i>
                                    </div>
                                    <div class="btn-content">
                                        <span class="btn-title">Seimbangkan Probabilitas</span>
                                        <small class="btn-subtitle">Bagi rata probabilitas semua hadiah</small>
                                    </div>
                                    <div class="btn-glow"></div>
                                </button>
                                <button class="quick-action-btn enhanced-quick-btn" id="reorder-prizes-btn">
                                    <div class="btn-icon-wrapper">
                                        <i class="fas fa-sort"></i>
                                    </div>
                                    <div class="btn-content">
                                        <span class="btn-title">Urutkan Ulang</span>
                                        <small class="btn-subtitle">Atur ulang posisi hadiah di roda</small>
                                    </div>
                                    <div class="btn-glow"></div>
                                </button>
                                <button class="quick-action-btn enhanced-quick-btn" id="backup-prizes-btn">
                                    <div class="btn-icon-wrapper">
                                        <i class="fas fa-download"></i>
                                    </div>
                                    <div class="btn-content">
                                        <span class="btn-title">Backup Data</span>
                                        <small class="btn-subtitle">Download konfigurasi hadiah</small>
                                    </div>
                                    <div class="btn-glow"></div>
                                </button>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Modal Preview Roda -->
        <div class="modal fade" id="previewWheelModal">
            <div class="modal-dialog modal-lg">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title"><i class="fas fa-eye"></i> Preview Roda Lucky Wheel</h5>
                        <button type="button" class="close-modal" data-dismiss="modal" title="Tutup" aria-label="Tutup modal" id="close-preview-wheel-modal">
                            <i class="fas fa-times"></i>
                        </button>
                    </div>
                    <div class="modal-body">
                        <iframe id="preview-wheel-iframe" src="../../index.html" title="Preview Lucky Wheel" tabindex="0"></iframe>
                    </div>
                </div>
            </div>
        </div>

        <!-- Toast Notification Container -->
        <div class="toast-container" id="toast-container"></div>

        <!-- Delete Confirmation Modal -->
        <div class="modal fade" id="deleteModal">
            <div class="modal-dialog">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title"><i class="fas fa-exclamation-triangle"></i> Konfirmasi Hapus</h5>
                        <button type="button" class="close-modal" data-dismiss="modal" title="Tutup" aria-label="Tutup modal">
                            <i class="fas fa-times"></i>
                        </button>
                    </div>
                    <div class="modal-body">
                        <p>Apakah Anda yakin ingin menghapus hadiah "<strong id="delete-prize-name"></strong>"?</p>
                        <p class="text-warning"><i class="fas fa-warning"></i> Tindakan ini tidak dapat dibatalkan!</p>
                    </div>
                    <div class="modal-actions">
                        <button type="button" class="btn-secondary" data-dismiss="modal">Batal</button>
                        <button type="button" class="btn-danger" id="confirm-delete-btn">Hapus</button>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- AOS Animation -->
    <script src="https://unpkg.com/aos@2.3.1/dist/aos.js"></script>
    <script src="js/prizes.js"></script>
    <script src="js/prizes-admin.js"></script>
    <script>
    // Definisi fungsi custom modal untuk hadiah
    function showCustomConfirm(message, title = 'Konfirmasi') {
        return new Promise((resolve) => {
            // Remove existing popup
            const existingPopup = document.querySelector('.custom-popup-overlay');
            if (existingPopup) {
                existingPopup.remove();
            }
            
            // Prevent body scroll
            document.body.classList.add('popup-open');
            
            // Create popup HTML
            const popupHTML = `
                <div class="custom-popup-overlay">
                    <div class="custom-popup">
                        <div class="custom-popup-icon warning">
                            <i class="fas fa-question-circle"></i>
                        </div>
                        <div class="custom-popup-title">${title}</div>
                        <div class="custom-popup-message">${message}</div>
                        <div class="custom-popup-buttons">
                            <button class="custom-popup-btn secondary" onclick="closeCustomPopup(false)">
                                <i class="fas fa-times"></i> Batal
                            </button>
                            <button class="custom-popup-btn primary" onclick="closeCustomPopup(true)">
                                <i class="fas fa-check"></i> Ya
                            </button>
                        </div>
                    </div>
                </div>
            `;
            
            // Add to body
            document.body.insertAdjacentHTML('beforeend', popupHTML);
            
            // Show popup with animation
            const popup = document.querySelector('.custom-popup-overlay');
            setTimeout(() => {
                popup.classList.add('show');
            }, 10);
            
            // Store resolve function
            window.customPopupResolve = resolve;
        });
    }
    
    function closeCustomPopup(result = true) {
        const popup = document.querySelector('.custom-popup-overlay');
        if (popup) {
            popup.classList.remove('show');
            // Restore body scroll
            document.body.classList.remove('popup-open');
            setTimeout(() => {
                popup.remove();
                if (window.customPopupResolve) {
                    window.customPopupResolve(result);
                    window.customPopupResolve = null;
                }
            }, 300);
        }
    }
    
    // Make functions global
    window.showCustomConfirm = showCustomConfirm;
    window.closeCustomPopup = closeCustomPopup;
    
    // Universal logout handler untuk hadiah
    document.addEventListener('DOMContentLoaded', function() {
        const logoutBtn = document.getElementById('logout-btn');
        if (logoutBtn && !logoutBtn.hasAttribute('data-logout-attached')) {
            logoutBtn.addEventListener('click', async function(event) {
                event.preventDefault();
                
                // Menggunakan showCustomConfirm jika tersedia
                let confirmed = false;
                if (typeof showCustomConfirm === 'function') {
                    confirmed = await showCustomConfirm('Apakah Anda yakin ingin keluar?', 'Konfirmasi Logout');
                } else {
                    confirmed = confirm('Apakah Anda yakin ingin keluar?');
                }
                
                if (!confirmed) return;
                
                try {
                    // Panggil endpoint logout untuk membersihkan session
                    await fetch('../login.php', {
                        method: 'POST',
                        headers: {
                            'Content-Type': 'application/json',
                            'X-Requested-With': 'XMLHttpRequest'
                        },
                        body: JSON.stringify({
                            action: 'logout'
                        })
                    });
                } catch (error) {
                    console.error('Logout error:', error);
                }
                
                // Redirect ke halaman login
                window.location.href = '../index.html';
            });
            
            logoutBtn.setAttribute('data-logout-attached', '1');
        }
    });
    </script>
    <script>
    // Fallback: pastikan tombol Test Spin selalu ada dan aktif
    document.addEventListener('DOMContentLoaded', function() {
        // Modal Preview Roda
        var previewBtn = document.getElementById('preview-wheel-btn');
        var previewModal = document.getElementById('previewWheelModal');
        var closePreviewBtn = document.getElementById('close-preview-wheel-modal');
        if (previewBtn && previewModal) {
            previewBtn.addEventListener('click', function() {
                previewModal.classList.add('show');
                previewModal.style.display = 'block';
                document.body.classList.add('modal-open');
            });
        }
        if (closePreviewBtn && previewModal) {
            closePreviewBtn.addEventListener('click', function() {
                previewModal.classList.remove('show');
                previewModal.style.display = 'none';
                document.body.classList.remove('modal-open');
            });
        }
        // Tutup modal jika klik di luar konten
        if (previewModal) {
            previewModal.addEventListener('mousedown', function(e) {
                if (e.target === previewModal) {
                    previewModal.classList.remove('show');
                    previewModal.style.display = 'none';
                    document.body.classList.remove('modal-open');
                }
            });
        }
        var wheelSection = document.querySelector('.wheel-stats.enhanced-stats');
        var testBtn = document.getElementById('test-wheel-btn');
        if (!testBtn && wheelSection) {
            var btn = document.createElement('button');
            btn.className = 'enhanced-small-btn';
            btn.id = 'test-wheel-btn';
            btn.innerHTML = '<i class="fas fa-play"></i> Test Spin';
            wheelSection.appendChild(btn);
            testBtn = btn;
        }
        if (testBtn) {
            testBtn.onclick = function() {
                if (typeof loadPrizes === 'function' && typeof testWheelSpin === 'function') {
                    loadPrizes(function() {
                        testWheelSpin(prizes.slice());
                    });
                } else {
                    alert('Fungsi test spin tidak ditemukan!');
                }
            };
        }
    });
    </script>
</body>
</html>
