<?php
// Include application configuration
require_once __DIR__ . '/../config/app-config.php';

// Security headers
header('X-Content-Type-Options: nosniff');
header('X-Frame-Options: DENY');
header('X-XSS-Protection: 1; mode=block');
header('Referrer-Policy: strict-origin-when-cross-origin');

// Include database configuration
require_once 'config/database.php';

// Basic security - check if user is logged in for admin sections
$isLoggedIn = isset($_SESSION['admin_logged_in']) && $_SESSION['admin_logged_in'] === true;
$adminUsername = isset($_SESSION['admin_username']) ? $_SESSION['admin_username'] : 'Administrator';

// Generate CSRF token for forms
$csrfToken = generateCSRFToken();

// Get current timestamp for cache busting
$version = APP_VERSION . '.' . time();
?>
<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Admin Panel - Lucky Wheel</title>
    <link rel="stylesheet" href="css/admin.css?v=<?php echo $version; ?>">
    <!-- Font Awesome -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
</head>
<body>
    <div class="admin-container">        <header class="admin-header">
            <div class="header-left">
                <div class="logo">
                    <img src="https://macau.lembagatooto.co/assets/img/bgy/logo.png?v=123" alt="Lucky Wheel Logo">
                </div>
                <div class="header-title">
                    <h1>Admin Panel</h1>
                    <p class="subtitle">Lucky Wheel Management System</p>
                </div>
            </div>
            <div class="header-right">
                <div class="admin-greeting">
                    <i class="fas fa-user-shield"></i>
                    <span>Selamat datang, <?php echo htmlspecialchars($adminUsername); ?></span>
                </div>
            </div>
        </header>        <div class="login-section" id="login-section">
            <div class="login-background">
                <div class="floating-shapes">
                    <div class="shape shape-1"></div>
                    <div class="shape shape-2"></div>
                    <div class="shape shape-3"></div>
                    <div class="shape shape-4"></div>
                </div>
            </div>
            <div class="login-box">
                <div class="login-header">
                    <div class="login-icon">
                        <i class="fas fa-shield-alt"></i>
                    </div>
                    <h2><i class="fas fa-crown"></i> Admin Login</h2>
                    <p class="login-subtitle">Akses Panel Manajemen Lucky Wheel</p>
                </div>
                
                <div class="login-welcome">
                    <h3><i class="fas fa-star"></i> Selamat Datang</h3>
                    <p>Masuk ke panel admin untuk mengelola voucher dan mengatur sistem Lucky Wheel</p>
                </div>
                
                <div class="login-form">
                    <div class="input-group">
                        <div class="input-icon">
                            <i class="fas fa-user"></i>
                        </div>
                        <input type="text" id="username" placeholder=" " required>
                        <label for="username"><i class="fas fa-user-tie"></i> Username Admin</label>
                    </div>
                    <div class="input-group">
                        <div class="input-icon">
                            <i class="fas fa-lock"></i>
                        </div>
                        <input type="password" id="password" placeholder=" " required>
                        <label for="password"><i class="fas fa-key"></i> Password Rahasia</label>
                    </div>
                    <button id="login-btn" class="admin-btn login-button">
                        <span class="btn-text">MASUK ADMIN</span>
                        <span class="btn-icon"><i class="fas fa-sign-in-alt"></i></span>
                    </button>
                </div>
                <div class="login-footer">
                    <p><i class="fas fa-info-circle"></i> Gunakan kredensial admin yang telah diberikan untuk mengakses panel</p>
                </div>
            </div>
        </div>

        <main class="admin-main hidden" id="admin-panel">
            <div class="admin-sidebar">
                <nav class="admin-nav">
                    <ul>
                        <li class="active" data-tab="vouchers-section"><i class="fas fa-ticket-alt"></i> Voucher</li>
                        <li data-tab="users-section"><i class="fas fa-users"></i> Pengguna</li>
                        <li data-tab="settings-section"><i class="fas fa-cog"></i> Pengaturan</li>
                    </ul>
                </nav>
                <div class="admin-user">
                    <div class="user-avatar">
                        <i class="fas fa-user-circle"></i>
                    </div>
                    <div class="user-info">
                        <p class="user-name">Admin</p>
                        <button id="logout-btn" class="small-btn"><i class="fas fa-sign-out-alt"></i> Logout</button>
                    </div>
                </div>
            </div>

            <div class="admin-content">
                <!-- Voucher Section -->
                <section id="vouchers-section" class="tab-content active">
                    <div class="section-header">
                        <h2>Manajemen Voucher</h2>
                        <button id="refresh-vouchers" class="small-btn"><i class="fas fa-sync-alt"></i> Refresh</button>
                    </div>

                    <div class="action-cards">
                        <div class="action-card">
                            <h3>Generate Voucher Baru</h3>
                            <div class="form-group">
                                <label for="voucher-count">Jumlah Voucher:</label>
                                <input type="number" id="voucher-count" value="1" min="1" max="100">
                            </div>
                            <div class="form-group">
                                <label for="voucher-type">Jenis Voucher:</label>
                                <select id="voucher-type">
                                    <option value="regular">Regular (1x Spin)</option>
                                    <option value="premium">Premium (3x Spin)</option>
                                    <option value="vip">VIP (5x Spin + Bonus)</option>
                                </select>
                            </div>
                            <div class="form-group">
                                <label for="expiry-date">Tanggal Kadaluarsa:</label>
                                <input type="date" id="expiry-date">
                            </div>
                            <button id="generate-btn" class="admin-btn"><i class="fas fa-plus-circle"></i> Generate</button>
                        </div>

                        <div class="action-card">
                            <h3>Statistik Voucher</h3>
                            <div class="stats-grid">
                                <div class="stat-box">
                                    <span class="stat-value" id="total-vouchers">0</span>
                                    <span class="stat-label">Total Voucher</span>
                                </div>
                                <div class="stat-box">
                                    <span class="stat-value" id="used-vouchers">0</span>
                                    <span class="stat-label">Terpakai</span>
                                </div>
                                <div class="stat-box">
                                    <span class="stat-value" id="active-vouchers">0</span>
                                    <span class="stat-label">Aktif</span>
                                </div>
                                <div class="stat-box">
                                    <span class="stat-value" id="expired-vouchers">0</span>
                                    <span class="stat-label">Kadaluarsa</span>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="table-container">
                        <table class="vouchers-table">
                            <thead>
                                <tr>
                                    <th>Kode Voucher</th>
                                    <th>Tanggal Dibuat</th>
                                    <th>Jenis</th>
                                    <th>Kadaluarsa</th>
                                    <th>Status</th>
                                    <th>Tindakan</th>
                                </tr>
                            </thead>
                            <tbody id="vouchers-list">
                                <!-- Voucher data will be filled by JS -->
                            </tbody>
                        </table>
                    </div>

                    <!-- Export Section -->
                    <div class="export-section">
                        <h3>Export Voucher</h3>
                        <div class="export-options">
                            <button id="export-csv" class="action-btn"><i class="fas fa-file-csv"></i> Export CSV</button>
                            <button id="export-json" class="action-btn"><i class="fas fa-file-code"></i> Export JSON</button>
                            <button id="print-vouchers" class="action-btn"><i class="fas fa-print"></i> Print</button>
                        </div>
                    </div>
                </section>

                <!-- Users Section -->
                <section id="users-section" class="tab-content">
                    <h2>Manajemen Pengguna</h2>
                    <p>Halaman manajemen pengguna. Fitur ini akan ditambahkan nanti.</p>
                </section>

                <!-- Settings Section -->
                <section id="settings-section" class="tab-content">
                    <h2>Pengaturan</h2>
                    <p>Halaman pengaturan. Fitur ini akan ditambahkan nanti.</p>
                </section>
            </div>
        </main>
    </div>

    <script src="js/admin.js"></script>
    <script>
    // Definisi fungsi custom modal untuk admin index
    function showCustomConfirm(message, title = 'Konfirmasi') {
        return new Promise((resolve) => {
            // Remove existing popup
            const existingPopup = document.querySelector('.custom-popup-overlay');
            if (existingPopup) {
                existingPopup.remove();
            }
            
            // Prevent body scroll
            document.body.classList.add('popup-open');
            
            // Create popup HTML
            const popupHTML = `
                <div class="custom-popup-overlay">
                    <div class="custom-popup">
                        <div class="custom-popup-icon warning">
                            <i class="fas fa-question-circle"></i>
                        </div>
                        <div class="custom-popup-title">${title}</div>
                        <div class="custom-popup-message">${message}</div>
                        <div class="custom-popup-buttons">
                            <button class="custom-popup-btn secondary" onclick="closeCustomPopup(false)">
                                <i class="fas fa-times"></i> Batal
                            </button>
                            <button class="custom-popup-btn primary" onclick="closeCustomPopup(true)">
                                <i class="fas fa-check"></i> Ya
                            </button>
                        </div>
                    </div>
                </div>
            `;
            
            // Add to body
            document.body.insertAdjacentHTML('beforeend', popupHTML);
            
            // Show popup with animation
            const popup = document.querySelector('.custom-popup-overlay');
            setTimeout(() => {
                popup.classList.add('show');
            }, 10);
            
            // Store resolve function
            window.customPopupResolve = resolve;
        });
    }
    
    function closeCustomPopup(result = true) {
        const popup = document.querySelector('.custom-popup-overlay');
        if (popup) {
            popup.classList.remove('show');
            // Restore body scroll
            document.body.classList.remove('popup-open');
            setTimeout(() => {
                popup.remove();
                if (window.customPopupResolve) {
                    window.customPopupResolve(result);
                    window.customPopupResolve = null;
                }
            }, 300);
        }
    }
    
    // Make functions global
    window.showCustomConfirm = showCustomConfirm;
    window.closeCustomPopup = closeCustomPopup;
    
    // Universal logout handler untuk admin/index.html
    document.addEventListener('DOMContentLoaded', function() {
        const logoutBtn = document.getElementById('logout-btn');
        if (logoutBtn) {
            logoutBtn.addEventListener('click', async function(event) {
                event.preventDefault();
                
                // Menggunakan fungsi showCustomConfirm jika tersedia, atau fallback ke confirm biasa
                let confirmed = false;
                if (typeof showCustomConfirm === 'function') {
                    confirmed = await showCustomConfirm('Apakah Anda yakin ingin keluar?', 'Konfirmasi Logout');
                } else {
                    confirmed = confirm('Apakah Anda yakin ingin keluar?');
                }
                
                if (!confirmed) return;
                
                try {
                    // Panggil endpoint logout untuk membersihkan session
                    await fetch('login.php', {
                        method: 'POST',
                        headers: {
                            'Content-Type': 'application/json',
                            'X-Requested-With': 'XMLHttpRequest'
                        },
                        body: JSON.stringify({
                            action: 'logout'
                        })
                    });
                } catch (error) {
                    console.error('Logout error:', error);
                }
                
                // Redirect ke halaman login
                window.location.href = 'login.php';
            });
        }
    });
    </script>
</body>
</html>
