<?php
// Script untuk membuat tabel database Lucky Wheel Statistics
require_once 'config/database.php';
try {
    // Tabel untuk menyimpan statistik spin
    $createSpinsTable = "
    CREATE TABLE IF NOT EXISTS lucky_wheel_spins (
        id INT AUTO_INCREMENT PRIMARY KEY,
        prize_name VARCHAR(100) NOT NULL,
        prize_type ENUM('jackpot', 'cash', 'bonus', 'voucher', 'try_again') NOT NULL,
        spin_date DATE NOT NULL,
        spin_time TIME NOT NULL,
        created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP
    ) ENGINE=InnoDB;
    ";
    // Tabel untuk menyimpan statistik penggunaan voucher
    $createVoucherUsageTable = "
    CREATE TABLE IF NOT EXISTS lucky_wheel_voucher_usage (
        id INT AUTO_INCREMENT PRIMARY KEY,
        voucher_code VARCHAR(50) NOT NULL,
        voucher_type ENUM('regular', 'premium', 'vip') NOT NULL,
        usage_date DATE NOT NULL,
        usage_time TIME NOT NULL,
        created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP
    ) ENGINE=InnoDB;
    ";
    // Tabel untuk menyimpan statistik harian
    $createDailyStatsTable = "
    CREATE TABLE IF NOT EXISTS lucky_wheel_daily_stats (
        id INT AUTO_INCREMENT PRIMARY KEY,
        stat_date DATE NOT NULL UNIQUE,
        total_spins INT DEFAULT 0,
        total_vouchers_used INT DEFAULT 0,
        total_prizes_claimed INT DEFAULT 0,
        jackpot_count INT DEFAULT 0,
        cash_prizes_count INT DEFAULT 0,
        bonus_count INT DEFAULT 0,
        voucher_prizes_count INT DEFAULT 0,
        try_again_count INT DEFAULT 0,
        updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
    ) ENGINE=InnoDB;
    ";
    // Eksekusi query
    $pdo->exec($createSpinsTable);
    echo "✅ Tabel 'lucky_wheel_spins' berhasil dibuat atau sudah ada.\n";
    $pdo->exec($createVoucherUsageTable);
    echo "✅ Tabel 'lucky_wheel_voucher_usage' berhasil dibuat atau sudah ada.\n";
    $pdo->exec($createDailyStatsTable);
    echo "✅ Tabel 'lucky_wheel_daily_stats' berhasil dibuat atau sudah ada.\n";
    echo "\n🎉 Semua tabel Lucky Wheel Statistics berhasil dibuat!\n";
    echo "\nTabel yang dibuat:\n";
    echo "1. lucky_wheel_spins - Menyimpan detail setiap spin\n";
    echo "2. lucky_wheel_voucher_usage - Menyimpan penggunaan voucher\n";
    echo "3. lucky_wheel_daily_stats - Menyimpan statistik harian\n";
} catch (PDOException $e) {
    echo "❌ Error membuat tabel: " . $e->getMessage() . "\n";
}
?>
