<?php
require_once 'config/database.php';
try {
    // Create lucky_wheel_prizes table
    $sql_prizes = "CREATE TABLE IF NOT EXISTS lucky_wheel_prizes (
        id INT AUTO_INCREMENT PRIMARY KEY,
        name VARCHAR(255) NOT NULL,
        type ENUM('money', 'voucher', 'freespin', 'bonus', 'other') NOT NULL DEFAULT 'money',
        value VARCHAR(100) NOT NULL,
        icon VARCHAR(50) DEFAULT 'fas fa-gift',
        color VARCHAR(7) DEFAULT '#FF6600',
        status ENUM('active', 'inactive') NOT NULL DEFAULT 'active',
        probability DECIMAL(5,2) NOT NULL DEFAULT 10.00,
        position INT NOT NULL DEFAULT 0,
        created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
        updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
    )";
    $pdo->exec($sql_prizes);
    echo "✅ Tabel 'lucky_wheel_prizes' berhasil dibuat!<br>";
    // Insert default prizes
    $default_prizes = [
        ['name' => '10.000 Rupiah', 'type' => 'money', 'value' => '10000', 'icon' => 'fas fa-coins', 'color' => '#FFD700', 'probability' => 20.00, 'position' => 1],
        ['name' => '25.000 Rupiah', 'type' => 'money', 'value' => '25000', 'icon' => 'fas fa-coins', 'color' => '#FF6600', 'probability' => 15.00, 'position' => 2],
        ['name' => '50.000 Rupiah', 'type' => 'money', 'value' => '50000', 'icon' => 'fas fa-coins', 'color' => '#FF0000', 'probability' => 10.00, 'position' => 3],
        ['name' => 'Free Spin', 'type' => 'freespin', 'value' => '1', 'icon' => 'fas fa-redo-alt', 'color' => '#00FF00', 'probability' => 25.00, 'position' => 4],
        ['name' => 'Voucher 20%', 'type' => 'voucher', 'value' => '20', 'icon' => 'fas fa-ticket-alt', 'color' => '#0066FF', 'probability' => 15.00, 'position' => 5],
        ['name' => 'Bonus Credit', 'type' => 'bonus', 'value' => '5000', 'icon' => 'fas fa-star', 'color' => '#9966FF', 'probability' => 10.00, 'position' => 6],
        ['name' => 'Coba Lagi', 'type' => 'other', 'value' => '0', 'icon' => 'fas fa-times', 'color' => '#666666', 'probability' => 5.00, 'position' => 7]
    ];
    $stmt = $pdo->prepare("INSERT INTO lucky_wheel_prizes (name, type, value, icon, color, probability, position) VALUES (?, ?, ?, ?, ?, ?, ?)");
    foreach ($default_prizes as $prize) {
        $stmt->execute([$prize['name'], $prize['type'], $prize['value'], $prize['icon'], $prize['color'], $prize['probability'], $prize['position']]);
    }
    echo "✅ Data default prizes berhasil ditambahkan!<br>";
    echo "🎉 Setup database prizes selesai!";
} catch (PDOException $e) {
    echo "❌ Error: " . $e->getMessage();
}
?>
