<?php
require_once 'config/database.php';
try {
    // Create vouchers table
    $sql = "CREATE TABLE IF NOT EXISTS vouchers (
        id VARCHAR(50) PRIMARY KEY,
        code VARCHAR(20) UNIQUE NOT NULL,
        type ENUM('discount', 'cashback', 'freespin', 'bonus') NOT NULL,
        value DECIMAL(10,2) NOT NULL,
        prefix VARCHAR(10),
        expiry_date DATE NOT NULL,
        usage_limit INT DEFAULT 1,
        used_count INT DEFAULT 0,
        is_used BOOLEAN DEFAULT FALSE,
        created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
        created_by VARCHAR(50) DEFAULT 'Admin',
        updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
    )";
    $pdo->exec($sql);
    // Create voucher usage log table
    $sql2 = "CREATE TABLE IF NOT EXISTS voucher_usage_log (
        id INT AUTO_INCREMENT PRIMARY KEY,
        voucher_id VARCHAR(50) NOT NULL,
        voucher_code VARCHAR(20) NOT NULL,
        used_by VARCHAR(100),
        used_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
        ip_address VARCHAR(45),
        user_agent TEXT,
        FOREIGN KEY (voucher_id) REFERENCES vouchers(id) ON DELETE CASCADE
    )";
    $pdo->exec($sql2);
    echo "Tables created successfully!";
} catch(PDOException $e) {
    echo "Error creating tables: " . $e->getMessage();
}
?>
