<?php
// Test Database Connection untuk debugging
ini_set('display_errors', 1);
error_reporting(E_ALL);

echo "<h1>Database Connection Test</h1>";

// Database configuration
$host = 'localhost';
$dbname = 'lucky_wheel_admin';
$username = 'lucky_wheel_user';
$password = 'Your_Strong_DB_Password_Here!';

echo "<h2>1. Testing Database Connection</h2>";
echo "Host: $host<br>";
echo "Database: $dbname<br>";
echo "Username: $username<br>";
echo "Password: " . (empty($password) ? "EMPTY!" : "SET") . "<br><br>";

try {
    // Test connection
    $pdo = new PDO("mysql:host=$host;dbname=$dbname;charset=utf8mb4", $username, $password);
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
    
    echo "<div style='color: green;'>✅ Database connection SUCCESS!</div><br>";
    
    // Test if tables exist
    echo "<h2>2. Checking Required Tables</h2>";
    
    $tables = [
        'lucky_wheel_daily_stats',
        'lucky_wheel_spins',
        'admin_users',
        'vouchers',
        'wheel_prizes'
    ];
    
    foreach ($tables as $table) {
        try {
            $result = $pdo->query("SHOW TABLES LIKE '$table'");
            if ($result->rowCount() > 0) {
                echo "<div style='color: green;'>✅ Table '$table' exists</div>";
                
                // Count records
                $count = $pdo->query("SELECT COUNT(*) FROM $table")->fetchColumn();
                echo " - Records: $count<br>";
            } else {
                echo "<div style='color: red;'>❌ Table '$table' NOT FOUND!</div><br>";
            }
        } catch (Exception $e) {
            echo "<div style='color: red;'>❌ Error checking table '$table': " . $e->getMessage() . "</div><br>";
        }
    }
    
    // Test API call
    echo "<h2>3. Testing API Call</h2>";
    
    try {
        // Simulate the same query as get-lucky-wheel-stats.php
        $totalStats = $pdo->query("
            SELECT
                COALESCE(SUM(total_spins), 0) as total_spins,
                COALESCE(SUM(total_vouchers_used), 0) as total_vouchers_used,
                COALESCE(SUM(total_prizes_claimed), 0) as total_prizes_claimed,
                COALESCE(SUM(jackpot_count), 0) as jackpot_count,
                COALESCE(SUM(cash_prizes_count), 0) as cash_prizes_count,
                COALESCE(SUM(bonus_count), 0) as bonus_count,
                COALESCE(SUM(voucher_prizes_count), 0) as voucher_prizes_count,
                COALESCE(SUM(try_again_count), 0) as try_again_count
            FROM lucky_wheel_daily_stats
        ")->fetch(PDO::FETCH_ASSOC);
        
        echo "<div style='color: green;'>✅ Stats query SUCCESS!</div>";
        echo "<pre>" . print_r($totalStats, true) . "</pre>";
        
    } catch (Exception $e) {
        echo "<div style='color: red;'>❌ Stats query FAILED: " . $e->getMessage() . "</div><br>";
    }
    
} catch (PDOException $e) {
    echo "<div style='color: red;'>❌ Database connection FAILED!</div>";
    echo "<div style='color: red;'>Error: " . $e->getMessage() . "</div><br>";
    
    echo "<h2>Possible Solutions:</h2>";
    echo "<ol>";
    echo "<li>Update database password in config/database.php</li>";
    echo "<li>Create database 'lucky_wheel_admin' in MySQL</li>";
    echo "<li>Create database user 'lucky_wheel_user' with proper privileges</li>";
    echo "<li>Run table creation scripts from setup/ folder</li>";
    echo "</ol>";
}

echo "<h2>4. Recommendations</h2>";
echo "<ol>";
echo "<li><strong>Update Database Credentials:</strong> Change placeholder password in config/database.php</li>";
echo "<li><strong>Create Database:</strong> Run: CREATE DATABASE lucky_wheel_admin;</li>";
echo "<li><strong>Create User:</strong> CREATE USER 'lucky_wheel_user'@'localhost' IDENTIFIED BY 'your_password';</li>";
echo "<li><strong>Grant Privileges:</strong> GRANT ALL PRIVILEGES ON lucky_wheel_admin.* TO 'lucky_wheel_user'@'localhost';</li>";
echo "<li><strong>Create Tables:</strong> Run SQL scripts from setup/ folder</li>";
echo "</ol>";
?>
