<?php
// CORS Security - Protect from unauthorized access
require_once '../../config/cors-security.php';
CorsManager::setSecureHeaders();
CorsManager::handlePreflightRequest();

// Include production config
require_once '../../config/production.php';

header('Content-Type: application/json');
header('Access-Control-Allow-Methods: POST');
header('Access-Control-Allow-Headers: Content-Type');
require_once __DIR__ . '/../config/database.php';
if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    http_response_code(405);
    echo json_encode(['success' => false, 'message' => 'Method not allowed']);
    exit;
}
$input = json_decode(file_get_contents('php://input'), true);
// Fitur hapus voucher
if (isset($input['action']) && $input['action'] === 'delete' && isset($input['code'])) {
    $code = $input['code'];
    try {
        $stmt = $pdo->prepare("DELETE FROM vouchers WHERE code = ?");
        $stmt->execute([$code]);
        echo json_encode(['success' => true, 'message' => 'Voucher deleted successfully']);
    } catch (Exception $e) {
        http_response_code(500);
        echo json_encode(['success' => false, 'message' => 'Error deleting voucher: ' . $e->getMessage()]);
    }
    exit;
}
if (!$input || !isset($input['code'], $input['name'], $input['prize_name'], $input['status'], $input['expiry_date'])) {
    http_response_code(400);
    echo json_encode(['success' => false, 'message' => 'Missing required fields']);
    exit;
}
$code = $input['code'];
$name = $input['name'];
$prizeName = $input['prize_name'];
$status = $input['status'];
$expiry = $input['expiry_date'];
try {
    $stmt = $pdo->prepare("UPDATE vouchers SET name=?, prize_name=?, status=?, expiry_date=? WHERE code=?");
    $stmt->execute([$name, $prizeName, $status, $expiry, $code]);
    echo json_encode(['success' => true, 'message' => 'Voucher updated successfully']);
} catch (Exception $e) {
    http_response_code(500);
    echo json_encode(['success' => false, 'message' => 'Error updating voucher: ' . $e->getMessage()]);
}
